/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.helper;

import java.util.Arrays;

public final class CodeFormatter {
    private static final int RIGHTMARGIN = 80;

    private CodeFormatter() {
    }

    public static String SingleLineComment(String Line) {
        return CodeFormatter.SingleLineComment(Line, 1);
    }

    public static String SingleLineComment(String Line, int StartColumn) {
        int length = Line.length();
        int i = 0;
        while (i < 74 - length - (StartColumn - 1)) {
            Line = String.valueOf(Line) + " ";
            ++i;
        }
        Line = "/* " + Line + " */";
        i = 0;
        while (i < StartColumn - 1) {
            Line = " " + Line;
            ++i;
        }
        return Line;
    }

    public static String MultiLineComment(String CommentText) {
        return CodeFormatter.MultiLineComment(CommentText, 1);
    }

    public static String MultiLineComment(String CommentText, int StartColumn) {
        String[] commentLineSepArray;
        String content = "";
        int counter = 0;
        String lineSeparator = System.getProperties().getProperty("line.separator");
        String[] stringArray = commentLineSepArray = CommentText.split(lineSeparator);
        int n = commentLineSepArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            content = String.valueOf(content) + CodeFormatter.SingleLineComment(s, StartColumn);
            if (commentLineSepArray.length - 1 > counter) {
                content = String.valueOf(content) + lineSeparator;
            }
            ++counter;
            ++n2;
        }
        return content;
    }

    public static String pad(String src, int padTo, char padChar) {
        int numPad = padTo - src.length();
        if (numPad > 0) {
            StringBuffer sb = new StringBuffer();
            char[] pad = new char[numPad];
            Arrays.fill(pad, padChar);
            sb.append(src);
            sb.append(pad);
            return sb.toString();
        }
        return src;
    }
}

