/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.helper;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class FileSystemUtils {
    private FileSystemUtils() {
    }

    private static void createFolderRecursively(IFolder path) throws CoreException {
        if (!path.exists()) {
            if (!path.getParent().exists()) {
                FileSystemUtils.createFolderRecursively((IFolder)path.getParent());
            }
            path.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IFolder createNewFoldersInWorkingDirectory(IFolder workingDirectory, String path) throws Exception {
        IFolder fullPath = workingDirectory.getFolder(path);
        if (!fullPath.exists()) {
            FileSystemUtils.createFolderRecursively(fullPath);
        }
        return fullPath;
    }

    public static IFile createFileInWorkingDirectory(IFolder workingDirectory, String relativePath, String fileName) throws Exception {
        workingDirectory = FileSystemUtils.createNewFoldersInWorkingDirectory(workingDirectory, relativePath);
        return workingDirectory.getFile(fileName);
    }
}

