/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

class ContentWriter {
    private final File outputFile;
    private final String content;

    public ContentWriter(File outputFile, String content) {
        this.outputFile = outputFile;
        this.content = content;
    }

    public void writeContentToHarddisk() throws IOException {
        this.createFileOnHarddisk();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.outputFile)));
            printWriter.print(this.content);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(printWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)printWriter);
    }

    private void createFileOnHarddisk() throws IOException {
        if (this.outputFile == null) {
            throw new IOException("Output File is not set.");
        }
        Boolean fileExits = this.outputFile.exists();
        if (!fileExits.booleanValue()) {
            this.outputFile.getParentFile().mkdirs();
            fileExits = this.outputFile.createNewFile();
        }
        if (!fileExits.booleanValue()) {
            throw new IOException("Could not create " + this.outputFile);
        }
    }
}

