/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.jet;

import com.proalpha.pds.templates.Activator;
import com.proalpha.pds.templates.jet.IpaTemplateGenerator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class JetTemplateFactory {
    private static final String COM_PROALPHA_PDS_TEMPLATES = "com.proalpha.pds.templates";
    private static final String JET_FOLDER = ".jet.";
    private static final String TRUNK = "trunk.";
    private static final String VERSION = "version";
    private String proALPHAVersion;
    private static JetTemplateFactory factory;

    public static JetTemplateFactory getFactoryInstance(String proALPHAVersion) {
        if (factory == null) {
            factory = new JetTemplateFactory(proALPHAVersion);
        } else {
            JetTemplateFactory.factory.proALPHAVersion = proALPHAVersion;
        }
        return factory;
    }

    private JetTemplateFactory(String proALPHAVersion) {
        this.proALPHAVersion = proALPHAVersion;
    }

    public IpaTemplateGenerator getTemplate(String instanceName) throws Exception {
        IpaTemplateGenerator template = null;
        try {
            try {
                template = this.getSelectedTemplate("com.proalpha.pds.templates.jet.version" + this.getProalphaVersionNumber(JetTemplateFactory.factory.proALPHAVersion) + instanceName);
            }
            catch (ClassNotFoundException e) {
                template = this.getSelectedTemplate("com.proalpha.pds.templates.jet.trunk." + instanceName);
            }
        }
        catch (Exception e) {
            this.logErrorMessage(e);
        }
        return template;
    }

    private void logErrorMessage(Throwable exception) {
        String message = exception.getMessage().length() >= 0 ? exception.getMessage() : "The error message could not be extracted. Please check the error log.";
        Status status = new Status(4, COM_PROALPHA_PDS_TEMPLATES, message);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    private IpaTemplateGenerator getSelectedTemplate(String instanceName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Bundle bundle = Platform.getBundle((String)COM_PROALPHA_PDS_TEMPLATES);
        Class myClass = bundle.loadClass(instanceName);
        IpaTemplateGenerator template = (IpaTemplateGenerator)myClass.newInstance();
        return template;
    }

    private String extractPointFromString(String proVersion) {
        String proALPHANumber = proVersion.replace(".", "");
        proALPHANumber = proALPHANumber.substring(0, 2);
        proALPHANumber = String.valueOf(proALPHANumber) + ".";
        return proALPHANumber;
    }

    private String getProalphaVersionNumber(String proVersion) {
        if (proVersion.contains(".")) {
            proVersion = this.extractPointFromString(proVersion);
        }
        return proVersion;
    }
}

