/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.Bundle;

public class PaProjectSelection
extends TitleAreaDialog {
    private PaProject selectedProject = null;
    private List<PaProject> availableProjects = new CopyOnWriteArrayList<PaProject>();
    private TreeViewer treeViewer;
    public static final Image icon = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.ui"), (IPath)new Path("icons/selectproject.gif"), Collections.emptyMap())).createImage();

    public PaProjectSelection(Shell parentShell) {
        super(parentShell);
    }

    public PaProject getSelectedProject() {
        return this.selectedProject;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(container, 2048);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = 220;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.treeViewer.setContentProvider((IContentProvider)new ProjectProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.treeViewer.setInput(this.availableProjects);
        return area;
    }

    public void create() {
        super.create();
        this.setTitle("Project selection");
        this.setMessage("Select your proALPHA Project", 1);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        TreeItem[] items = this.treeViewer.getTree().getSelection();
        if (items != null && items.length > 0) {
            this.selectedProject = (PaProject)items[0].getData();
        }
        super.okPressed();
    }

    private class ProjectLabelProvider
    implements ILabelProvider {
        private ProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return icon;
        }

        public String getText(Object element) {
            if (element instanceof PaProject) {
                PaProject paProject = (PaProject)element;
                return paProject.getName().substring(2);
            }
            return "";
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    public class ProjectProvider
    implements ITreeContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            List paProjects = Activator.getDefault().getProjectManager().getPaProjects();
            PaProjectSelection.this.availableProjects.clear();
            paProjects.forEach(paProject -> {
                if (paProject.isAvailable() && paProject.getOeProject().getProject().isOpen()) {
                    PaProjectSelection.this.availableProjects.add(paProject);
                }
            });
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

