/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RayHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PaProject paProject = Activator.getDefault().getProjectManager().getPaProjectByTextSelection();
        if (paProject != null) {
            if (paProject.isAvailable()) {
                int rayPort = paProject.getRayPort();
                if (RayHandler.isRayAvailable("localhost", rayPort)) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("http://localhost:" + String.valueOf(rayPort) + "/skin-client/"));
                    }
                    catch (MalformedURLException | PartInitException e) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"pA Ray", (String)"Error while calling browser");
                    }
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"pA Ray", (String)"Ray not active");
                }
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"pA not available", (String)"no proALPHA Project available or still starting");
            }
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No Project", (String)"no proALPHA Project found");
        }
        return null;
    }

    public static boolean isRayAvailable(String host, int portNumber) {
        boolean isAvailable;
        if (portNumber == 0) {
            return false;
        }
        try {
            new Socket(host, portNumber).close();
            isAvailable = true;
        }
        catch (IOException e) {
            isAvailable = false;
        }
        return isAvailable;
    }
}

