/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.model.filter;

import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ComponentFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.EstimateVsActualFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueTypeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.PriorityFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ProjectFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.RelativeDateRangeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ResolutionFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.StatusFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.VersionFilter;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterDataExtractor {
    public abstract Collection<String> extractAssignedTo(UserFilter var1);

    public abstract Collection<String> extractComponents(ComponentFilter var1);

    public abstract Collection<String> extractDates(DateFilter var1, DateFormat var2);

    public abstract Collection<String> extractIssueTypes(IssueTypeFilter var1);

    public Collection<String> extractPriorities(PriorityFilter priorityFilter) {
        if (priorityFilter != null && priorityFilter.getPriorities() != null) {
            return this.getPriorityIds(Arrays.asList(priorityFilter.getPriorities()));
        }
        return Collections.emptyList();
    }

    public abstract Collection<String> extractProjects(ProjectFilter var1);

    public abstract Collection<String> extractReportedBy(UserFilter var1);

    public abstract Collection<String> extractResolutions(ResolutionFilter var1);

    public Collection<String> extractStatuses(StatusFilter statusFilter) {
        if (statusFilter != null && statusFilter.getStatuses() != null) {
            return this.getStatusIds(Arrays.asList(statusFilter.getStatuses()));
        }
        return Collections.emptyList();
    }

    public abstract Collection<String> extractVersions(VersionFilter var1);

    public abstract Collection<String> extractWorkRatios(EstimateVsActualFilter var1);

    protected Collection<String> getComponentIds(Collection<Component> components) {
        return Collections2.transform(components, (Function)new Function<Component, String>(){

            public String apply(Component from) {
                return from.getId();
            }
        });
    }

    protected Collection<String> getIssueTypeIds(Collection<IssueType> issueTypes) {
        return Collections2.transform(issueTypes, (Function)new Function<IssueType, String>(){

            public String apply(IssueType from) {
                return from.getId();
            }
        });
    }

    protected Collection<String> getIssueTypeNames(Collection<IssueType> issueTypes) {
        return Collections2.transform(issueTypes, (Function)new Function<IssueType, String>(){

            public String apply(IssueType from) {
                return FilterDataExtractor.putInDoubleQuotes(from.getName());
            }
        });
    }

    protected Collection<String> getPriorityIds(Collection<Priority> priorities) {
        return Collections2.transform(priorities, (Function)new Function<Priority, String>(){

            public String apply(Priority from) {
                return from.getId();
            }
        });
    }

    protected Collection<String> getResolutionIds(Collection<Resolution> resolutions) {
        return Collections2.transform(resolutions, (Function)new Function<Resolution, String>(){

            public String apply(Resolution from) {
                return from.getId();
            }
        });
    }

    protected Collection<? extends String> getResolutionNames(List<Resolution> resolutions) {
        return Collections2.transform(resolutions, (Function)new Function<Resolution, String>(){

            public String apply(Resolution from) {
                return FilterDataExtractor.putInDoubleQuotes(from.getName());
            }
        });
    }

    protected Collection<String> getStatusIds(Collection<JiraStatus> jiraStatuses) {
        return Collections2.transform(jiraStatuses, (Function)new Function<JiraStatus, String>(){

            public String apply(JiraStatus from) {
                return from.getId();
            }
        });
    }

    protected Collection<String> getProjectIds(List<Project> projects) {
        return Collections2.transform(projects, (Function)new Function<Project, String>(){

            public String apply(Project from) {
                return from.getId();
            }
        });
    }

    protected Collection<String> getProjectKeys(Collection<Project> projects) {
        return Collections2.transform(projects, (Function)new Function<Project, String>(){

            public String apply(Project from) {
                return from.getKey();
            }
        });
    }

    protected Collection<String> getVersionIds(Collection<Version> versions) {
        return Collections2.transform(versions, (Function)new Function<Version, String>(){

            public String apply(Version from) {
                return from.getId();
            }
        });
    }

    protected Collection<String> getVersionNames(Collection<Version> versions) {
        return Collections2.transform(versions, (Function)new Function<Version, String>(){

            public String apply(Version from) {
                return FilterDataExtractor.putInDoubleQuotes(from.getName());
            }
        });
    }

    public static String putInDoubleQuotes(String input) {
        return String.valueOf('\"') + input.replace("\"", "\\\"") + '\"';
    }

    public static String createRelativeDateString(RelativeDateRangeFilter.RangeType rangeType, long count) {
        StringBuilder sb = new StringBuilder();
        sb.append(Long.toString(count));
        if (RelativeDateRangeFilter.RangeType.MINUTE.equals(rangeType)) {
            sb.append('m');
        } else if (RelativeDateRangeFilter.RangeType.HOUR.equals(rangeType)) {
            sb.append('h');
        } else if (RelativeDateRangeFilter.RangeType.DAY.equals(rangeType)) {
            sb.append('d');
        } else if (RelativeDateRangeFilter.RangeType.WEEK.equals(rangeType)) {
            sb.append('w');
        }
        return sb.toString();
    }
}

