/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service;

import com.atlassian.connector.eclipse.internal.jira.core.InvalidJiraQueryException;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ClassicFilterDataExtractor;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ComponentFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ContentFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.CurrentUserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateRangeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.EstimateVsActualFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDataExtractor;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDefinition;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueTypeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.JQLFilterDataExtractor;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.JiraFieldSpecialValue;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.JiraFields;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.JiraFieldsNames;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.NobodyFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.Order;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.PriorityFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ProjectFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.RelativeDateRangeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ResolutionFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.SpecificUserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.StatusFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserInGroupFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.VersionFilter;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDefinitionConverter {
    private static final String JQL_SORT_DESCENDING = "DESC";
    private static final String JQL_SORT_ASCENDING = "ASC";
    private static final String JQL_ORDER_BY = " ORDER BY ";
    private static final String QUERY_KEY = "query";
    public static final DateFormat JQL_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final DateFormat JQL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final String encoding;
    private final DateFormat classicQueryDateTimeFormat;

    public FilterDefinitionConverter(String encoding, DateFormat dateFormat) {
        Assert.isNotNull((Object)dateFormat);
        Assert.isNotNull((Object)encoding);
        this.encoding = encoding;
        this.classicQueryDateTimeFormat = dateFormat;
    }

    public String toUrl(String repositoryUrl, FilterDefinition filter) {
        return String.valueOf(repositoryUrl) + "/secure/IssueNavigator.jspa?mode=hide" + "&reset=true" + this.getQueryParams(filter);
    }

    public String toJqlUrl(String repositoryUrl, FilterDefinition filter) throws UnsupportedEncodingException {
        return String.valueOf(repositoryUrl) + "/issues/?jql=" + URLEncoder.encode(this.getJqlString(filter), this.encoding);
    }

    public FilterDefinition toFilter(JiraClient client, String classicUrl, boolean validate) {
        try {
            return this.toFilter(client, classicUrl, validate, false, null);
        }
        catch (JiraException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public FilterDefinition toFilter(JiraClient client, String classicUrl, boolean validate, boolean update, IProgressMonitor monitor) throws JiraException, UnsupportedEncodingException {
        boolean bl;
        FilterDefinition filter = new FilterDefinition();
        int n = classicUrl.indexOf(63);
        if (n == -1) {
            return filter;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        String[] stringArray = classicUrl.substring(n + 1).split("&");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String pair = stringArray[n3];
            String[] tokens = pair.split("=");
            if (tokens.length > 1) {
                String key = tokens[0];
                String value = tokens.length == 1 ? "" : URLDecoder.decode((String)tokens[1], this.encoding);
                List<String> values = params.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                    params.put(key, values);
                }
                values.add(value);
            }
            ++n3;
        }
        JiraFieldsNames jiraField = JiraFieldsNames.createClassic();
        List<String> projectIds = this.getIds(params, jiraField.PROJECT());
        ArrayList<Project> projects = new ArrayList<Project>();
        for (String projectId : projectIds) {
            Project project = client.getCache().getProjectById(projectId);
            if (update && (project == null || !project.hasDetails())) {
                project = client.getCache().refreshProjectDetails(projectId, monitor);
            }
            if (project == null) {
                if (!validate) continue;
                throw new InvalidJiraQueryException("Unknown project " + projectId);
            }
            projects.add(project);
        }
        if (projects.size() > 0) {
            filter.setProjectFilter(new ProjectFilter(projects.toArray(new Project[projects.size()])));
            List<String> componentIds = this.getIds(params, jiraField.COMPONENT());
            LinkedHashSet<Object> components = new LinkedHashSet<Object>();
            LinkedHashSet<Version> versions = new LinkedHashSet<Version>();
            boolean hasNoComponent = false;
            for (Project project : projects) {
                if (!project.hasDetails()) continue;
                for (String string : componentIds) {
                    Object projectComponents;
                    Object object = projectComponents = project.getComponents();
                    int n4 = ((Object)object).length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Object component = object[n5];
                        if (((Component)component).getId().equals(string)) {
                            components.add(component);
                        }
                        ++n5;
                    }
                    if (!string.equals(JiraFieldSpecialValue.COMPONENT_NONE.getClassic())) continue;
                    hasNoComponent = true;
                }
                versions.addAll(Arrays.asList(project.getVersions()));
            }
            if (!componentIds.isEmpty()) {
                filter.setComponentFilter(new ComponentFilter(components.toArray(new Component[components.size()]), hasNoComponent));
            }
            Version[] projectVersions = versions.toArray(new Version[versions.size()]);
            filter.setFixForVersionFilter(this.createVersionFilter(this.getIds(params, jiraField.FIX_VERSION()), projectVersions));
            filter.setReportedInVersionFilter(this.createVersionFilter(this.getIds(params, jiraField.AFFECTED_VERSION()), projectVersions));
        }
        List<String> typeIds = this.getIds(params, JiraFields.ISSUE_TYPE.getClassic());
        ArrayList<IssueType> issueTypes = new ArrayList<IssueType>();
        for (String typeId : typeIds) {
            IssueType issueType = null;
            if (projects.size() > 0) {
                for (Project project : projects) {
                    issueType = project.getIssueTypeById(typeId);
                    if (issueType != null) break;
                }
            }
            if (issueType == null) {
                issueType = client.getCache().getIssueTypeById(typeId);
            }
            if (issueType != null) {
                issueTypes.add(issueType);
                continue;
            }
            if (!validate) continue;
            throw new InvalidJiraQueryException("Unknown type " + typeId);
        }
        if (!issueTypes.isEmpty()) {
            filter.setIssueTypeFilter(new IssueTypeFilter(issueTypes.toArray(new IssueType[issueTypes.size()])));
        }
        List<String> statusIds = this.getIds(params, JiraFields.STATUS.getClassic());
        ArrayList<JiraStatus> statuses = new ArrayList<JiraStatus>();
        for (String statusId : statusIds) {
            JiraStatus jiraStatus = client.getCache().getStatusById(statusId);
            if (jiraStatus != null) {
                statuses.add(jiraStatus);
                continue;
            }
            if (!validate) continue;
            throw new InvalidJiraQueryException("Unknown status " + statusId);
        }
        if (!statuses.isEmpty()) {
            filter.setStatusFilter(new StatusFilter(statuses.toArray(new JiraStatus[statuses.size()])));
        }
        List<String> resolutionIds = this.getIds(params, JiraFields.RESOLUTION.getClassic());
        ArrayList<Resolution> arrayList = new ArrayList<Resolution>();
        boolean bl2 = false;
        for (String resolutionId : resolutionIds) {
            if (!JiraFieldSpecialValue.UNRESOLVED.getClassic().equals(resolutionId)) {
                Resolution resolution = client.getCache().getResolutionById(resolutionId);
                if (resolution != null) {
                    arrayList.add(resolution);
                    continue;
                }
                if (!validate) continue;
                throw new InvalidJiraQueryException("Unknown resolution " + resolutionId);
            }
            bl = true;
        }
        if (!resolutionIds.isEmpty()) {
            filter.setResolutionFilter(new ResolutionFilter(arrayList.toArray(new Resolution[arrayList.size()])));
        } else if (bl) {
            filter.setResolutionFilter(new ResolutionFilter(new Resolution[0]));
        }
        List<String> priorityIds = this.getIds(params, JiraFields.PRIORITY.getClassic());
        ArrayList<Priority> priorities = new ArrayList<Priority>();
        for (String priorityId : priorityIds) {
            Priority priority = client.getCache().getPriorityById(priorityId);
            if (priority != null) {
                priorities.add(priority);
                continue;
            }
            if (!validate) continue;
            throw new InvalidJiraQueryException("Unknown priority " + priorityId);
        }
        if (!priorities.isEmpty()) {
            filter.setPriorityFilter(new PriorityFilter(priorities.toArray(new Priority[priorities.size()])));
        }
        List<String> queries = this.getIds(params, QUERY_KEY);
        for (String query : queries) {
            boolean searchSummary = this.getIds(params, jiraField.SUMMARY()).contains("true");
            boolean searchDescription = this.getIds(params, jiraField.DESCRIPTION()).contains("true");
            boolean searchEnvironment = this.getIds(params, jiraField.ENVIRONMENT()).contains("true");
            boolean searchComments = this.getIds(params, jiraField.COMMENT()).contains("true");
            filter.setContentFilter(new ContentFilter(query, searchSummary, searchDescription, searchEnvironment, searchComments));
        }
        filter.setReportedByFilter(this.createUserFilter(params, JiraFields.REPORTER.getClassic()));
        filter.setAssignedToFilter(this.createUserFilter(params, JiraFields.ASSIGNEE.getClassic()));
        filter.setCreatedDateFilter(this.createDateFilter(params, JiraFields.CREATED.getClassic()));
        filter.setUpdatedDateFilter(this.createDateFilter(params, JiraFields.UPDATED.getClassic()));
        filter.setDueDateFilter(this.createDateFilter(params, JiraFields.DUE_DATE.getClassic()));
        return filter;
    }

    public String getQueryParams(FilterDefinition filter) {
        StringBuilder sb = new StringBuilder();
        JiraFieldsNames jiraField = JiraFieldsNames.createClassic();
        ClassicFilterDataExtractor classicFilter = new ClassicFilterDataExtractor();
        this.addParameters(sb, jiraField.PROJECT(), ((FilterDataExtractor)classicFilter).extractProjects(filter.getProjectFilter()));
        this.addParameters(sb, jiraField.COMPONENT(), ((FilterDataExtractor)classicFilter).extractComponents(filter.getComponentFilter()));
        this.addParameters(sb, jiraField.FIX_VERSION(), ((FilterDataExtractor)classicFilter).extractVersions(filter.getFixForVersionFilter()));
        this.addParameters(sb, jiraField.AFFECTED_VERSION(), ((FilterDataExtractor)classicFilter).extractVersions(filter.getReportedInVersionFilter()));
        this.addParameters(sb, jiraField.ISSUE_TYPE(), ((FilterDataExtractor)classicFilter).extractIssueTypes(filter.getIssueTypeFilter()));
        this.addParameters(sb, jiraField.STATUS(), classicFilter.extractStatuses(filter.getStatusFilter()));
        this.addParameters(sb, jiraField.RESOLUTION(), ((FilterDataExtractor)classicFilter).extractResolutions(filter.getResolutionFilter()));
        this.addParameters(sb, jiraField.PRIORITY(), classicFilter.extractPriorities(filter.getPriorityFilter()));
        ContentFilter contentFilter = filter.getContentFilter();
        if (contentFilter != null) {
            String queryString = contentFilter.getQueryString();
            if (queryString != null) {
                this.addParameter(sb, QUERY_KEY, queryString);
            }
            if (contentFilter.isSearchingSummary()) {
                this.addParameter(sb, jiraField.SUMMARY(), "true");
            }
            if (contentFilter.isSearchingDescription()) {
                this.addParameter(sb, jiraField.DESCRIPTION(), "true");
            }
            if (contentFilter.isSearchingComments()) {
                this.addParameter(sb, jiraField.COMMENT(), "true");
            }
            if (contentFilter.isSearchingEnvironment()) {
                this.addParameter(sb, jiraField.ENVIRONMENT(), "true");
            }
        }
        this.addUserFilter(sb, filter.getReportedByFilter(), JiraFields.REPORTER.getClassic(), JiraFieldSpecialValue.ISSUE_NO_REPORTER.getClassic());
        this.addUserFilter(sb, filter.getAssignedToFilter(), JiraFields.ASSIGNEE.getClassic(), JiraFieldSpecialValue.UNASSIGNED.getClassic());
        this.addDateFilter(sb, filter.getCreatedDateFilter(), JiraFields.CREATED.getClassic());
        this.addDateFilter(sb, filter.getUpdatedDateFilter(), JiraFields.UPDATED.getClassic());
        this.addDateFilter(sb, filter.getDueDateFilter(), JiraFields.DUE_DATE.getClassic());
        this.addOrdering(sb, filter.getOrdering());
        EstimateVsActualFilter estimateFilter = filter.getEstimateVsActualFilter();
        if (estimateFilter != null) {
            long max;
            long min = estimateFilter.getMinVariation();
            if (min != 0L) {
                this.addParameter(sb, "minRatioLimit", Long.toString(min));
            }
            if ((max = estimateFilter.getMaxVariation()) != 0L) {
                this.addParameter(sb, "maxRatioLimit", Long.toString(max));
            }
        }
        return sb.toString();
    }

    public String getJqlString(FilterDefinition filter) {
        ArrayList<String> searchParams = new ArrayList<String>();
        JiraFieldsNames jiraField = JiraFieldsNames.createJql();
        JQLFilterDataExtractor jqlFilter = new JQLFilterDataExtractor();
        this.addJqlInExpression(searchParams, jiraField.PROJECT(), Collections2.transform(((FilterDataExtractor)jqlFilter).extractProjects(filter.getProjectFilter()), (Function)new Function<String, String>(){

            public String apply(String arg) {
                return "\"" + arg + "\"";
            }
        }));
        this.addJqlInExpression(searchParams, jiraField.COMPONENT(), ((FilterDataExtractor)jqlFilter).extractComponents(filter.getComponentFilter()));
        this.addJqlInExpression(searchParams, jiraField.FIX_VERSION(), ((FilterDataExtractor)jqlFilter).extractVersions(filter.getFixForVersionFilter()));
        this.addJqlInExpression(searchParams, jiraField.AFFECTED_VERSION(), ((FilterDataExtractor)jqlFilter).extractVersions(filter.getReportedInVersionFilter()));
        this.addJqlInExpression(searchParams, jiraField.ISSUE_TYPE(), ((FilterDataExtractor)jqlFilter).extractIssueTypes(filter.getIssueTypeFilter()));
        this.addJqlInExpression(searchParams, jiraField.STATUS(), jqlFilter.extractStatuses(filter.getStatusFilter()));
        this.addJqlInExpression(searchParams, jiraField.RESOLUTION(), ((FilterDataExtractor)jqlFilter).extractResolutions(filter.getResolutionFilter()));
        this.addJqlInExpression(searchParams, jiraField.PRIORITY(), jqlFilter.extractPriorities(filter.getPriorityFilter()));
        ContentFilter contentFilter = filter.getContentFilter();
        if (contentFilter != null && contentFilter.getQueryString() != null && contentFilter.getQueryString().length() > 0) {
            String searchedString = " ~ \"" + contentFilter.getQueryString() + "\"";
            ArrayList<String> jqlOrQueryParts = new ArrayList<String>(4);
            if (contentFilter.isSearchingSummary()) {
                jqlOrQueryParts.add(String.valueOf(jiraField.SUMMARY()) + searchedString);
            }
            if (contentFilter.isSearchingDescription()) {
                jqlOrQueryParts.add(String.valueOf(jiraField.DESCRIPTION()) + searchedString);
            }
            if (contentFilter.isSearchingComments()) {
                jqlOrQueryParts.add(String.valueOf(jiraField.COMMENT()) + searchedString);
            }
            if (contentFilter.isSearchingEnvironment()) {
                jqlOrQueryParts.add(String.valueOf(jiraField.ENVIRONMENT()) + searchedString);
            }
            this.addJqlOrExpression(searchParams, jqlOrQueryParts);
        }
        this.addJqlInExpression(searchParams, jiraField.REPORTER(), ((FilterDataExtractor)jqlFilter).extractReportedBy(filter.getReportedByFilter()));
        this.addJqlInExpression(searchParams, jiraField.ASSIGNEE(), ((FilterDataExtractor)jqlFilter).extractAssignedTo(filter.getAssignedToFilter()));
        this.addJqlAndExpression(searchParams, jiraField.CREATED(), ((FilterDataExtractor)jqlFilter).extractDates(filter.getCreatedDateFilter(), JQL_DATE_TIME_FORMAT));
        this.addJqlAndExpression(searchParams, jiraField.UPDATED(), ((FilterDataExtractor)jqlFilter).extractDates(filter.getUpdatedDateFilter(), JQL_DATE_TIME_FORMAT));
        this.addJqlAndExpression(searchParams, jiraField.DUE_DATE(), ((FilterDataExtractor)jqlFilter).extractDates(filter.getDueDateFilter(), JQL_DATE_FORMAT));
        this.addJqlAndExpression(searchParams, jiraField.WORK_RATIO(), ((FilterDataExtractor)jqlFilter).extractWorkRatios(filter.getEstimateVsActualFilter()));
        String whereClause = StringUtils.join(searchParams, (String)" AND ");
        String orderByClause = this.getJqlOrdering(filter.getOrdering());
        return String.valueOf(whereClause) + " " + orderByClause;
    }

    private VersionFilter createVersionFilter(List<String> fixForIds, Version[] projectVersions) {
        if (fixForIds.isEmpty()) {
            return null;
        }
        boolean hasNoVersions = false;
        boolean hasReleasedVersions = false;
        boolean hasUnreleasedVersions = false;
        ArrayList<Version> fixForversions = new ArrayList<Version>();
        for (String fixForId : fixForIds) {
            if (fixForId.equals(JiraFieldSpecialValue.VERSION_NONE.getClassic())) {
                hasNoVersions = true;
            }
            if (fixForId.equals(JiraFieldSpecialValue.VERSION_RELEASED.getClassic())) {
                hasReleasedVersions = true;
            }
            if (fixForId.equals(JiraFieldSpecialValue.VERSION_UNRELEASED.getClassic())) {
                hasUnreleasedVersions = true;
            }
            Version[] versionArray = projectVersions;
            int n = projectVersions.length;
            int n2 = 0;
            while (n2 < n) {
                Version projectVersion = versionArray[n2];
                if (projectVersion.getId().equals(fixForId)) {
                    fixForversions.add(projectVersion);
                }
                ++n2;
            }
        }
        return new VersionFilter(fixForversions.toArray(new Version[fixForversions.size()]), hasNoVersions, hasReleasedVersions, hasUnreleasedVersions);
    }

    private DateFilter createDateFilter(Map<String, List<String>> params, String key) {
        String after = this.getId(params, String.valueOf(key) + ":after");
        String before = this.getId(params, String.valueOf(key) + ":before");
        Date afterDate = null;
        try {
            if (after != null) {
                afterDate = this.classicQueryDateTimeFormat.parse(after);
            }
        }
        catch (ParseException parseException) {}
        Date beforeDate = null;
        try {
            if (before != null) {
                beforeDate = this.classicQueryDateTimeFormat.parse(before);
            }
        }
        catch (ParseException parseException) {}
        String previous = this.getId(params, String.valueOf(key) + ":previous");
        String next = this.getId(params, String.valueOf(key) + ":next");
        return afterDate == null && beforeDate == null && previous == null && next == null ? null : new DateRangeFilter(afterDate, beforeDate, previous, next);
    }

    private UserFilter createUserFilter(Map<String, List<String>> params, String key) {
        String type = this.getId(params, String.valueOf(key) + "Select");
        if (JiraFieldSpecialValue.ISSUE_NO_REPORTER.getClassic().equals(type) || JiraFieldSpecialValue.UNASSIGNED.getClassic().equals(type)) {
            return new NobodyFilter();
        }
        if (JiraFieldSpecialValue.ISSUE_CURRENT_USER.getClassic().equals(type)) {
            return new CurrentUserFilter();
        }
        String reporter = this.getId(params, key);
        if (reporter != null) {
            if (JiraFieldSpecialValue.ISSUE_SPECIFIC_USER.getClassic().equals(type)) {
                return new SpecificUserFilter(reporter);
            }
            if (JiraFieldSpecialValue.ISSUE_SPECIFIC_GROUP.getClassic().equals(type)) {
                return new UserInGroupFilter(reporter);
            }
        }
        return null;
    }

    private String getId(Map<String, List<String>> params, String key) {
        List<String> ids = this.getIds(params, key);
        return ids.isEmpty() ? null : ids.get(0);
    }

    private List<String> getIds(Map<String, List<String>> params, String key) {
        List<String> ids = params.get(key);
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids;
    }

    private String getJqlOrdering(Order[] ordering) {
        if (ordering.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(JQL_ORDER_BY);
        int i = 0;
        while (i < ordering.length) {
            sb.append(ordering[i].getField().getJql());
            sb.append(" ");
            sb.append(ordering[i].isAscending() ? JQL_SORT_ASCENDING : JQL_SORT_DESCENDING);
            if (i < ordering.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private String getOrdering(Order[] ordering) {
        StringBuilder sb = new StringBuilder();
        Order[] orderArray = ordering;
        int n = ordering.length;
        int n2 = 0;
        while (n2 < n) {
            Order order = orderArray[n2];
            String fieldName = order.getField().getClassic();
            if (fieldName != null) {
                this.addParameter(sb, "sorter/field", fieldName);
                this.addParameter(sb, "sorter/order", order.isAscending() ? JQL_SORT_ASCENDING : JQL_SORT_DESCENDING);
            }
            ++n2;
        }
        return sb.toString();
    }

    private void addOrdering(StringBuilder sb, Order[] ordering) {
        sb.append(this.getOrdering(ordering));
    }

    private void addDateFilter(StringBuilder sb, DateFilter filter, String type) {
        if (filter instanceof DateRangeFilter) {
            DateRangeFilter rangeFilter = (DateRangeFilter)filter;
            if (rangeFilter.getFromDate() != null) {
                this.addParameter(sb, String.valueOf(type) + ":after", this.classicQueryDateTimeFormat.format(rangeFilter.getFromDate()));
            }
            if (rangeFilter.getToDate() != null) {
                this.addParameter(sb, String.valueOf(type) + ":before", this.classicQueryDateTimeFormat.format(rangeFilter.getToDate()));
            }
            if (rangeFilter.getFrom() != null && rangeFilter.getFrom().length() > 0) {
                this.addParameter(sb, String.valueOf(type) + ":previous", rangeFilter.getFrom());
            }
            if (rangeFilter.getTo() != null && rangeFilter.getTo().length() > 0) {
                this.addParameter(sb, String.valueOf(type) + ":next", rangeFilter.getTo());
            }
        } else if (filter instanceof RelativeDateRangeFilter) {
            RelativeDateRangeFilter rangeFilter = (RelativeDateRangeFilter)filter;
            if (rangeFilter.previousMilliseconds() != 0L) {
                this.addParameter(sb, String.valueOf(type) + ":previous", FilterDataExtractor.createRelativeDateString(rangeFilter.getPreviousRangeType(), rangeFilter.getPreviousCount()));
            }
            if (rangeFilter.nextMilliseconds() != 0L) {
                this.addParameter(sb, String.valueOf(type) + ":next", FilterDataExtractor.createRelativeDateString(rangeFilter.getNextRangeType(), rangeFilter.getNextCount()));
            }
        }
    }

    private void addUserFilter(StringBuilder sb, UserFilter filter, String type, String nobodyText) {
        if (filter instanceof NobodyFilter) {
            this.addParameter(sb, String.valueOf(type) + "Select", nobodyText);
        } else if (filter instanceof CurrentUserFilter) {
            this.addParameter(sb, String.valueOf(type) + "Select", JiraFieldSpecialValue.ISSUE_CURRENT_USER.getClassic());
        } else if (filter instanceof SpecificUserFilter) {
            this.addParameter(sb, String.valueOf(type) + "Select", JiraFieldSpecialValue.ISSUE_SPECIFIC_USER.getClassic());
            this.addParameter(sb, type, ((SpecificUserFilter)filter).getUser());
        } else if (filter instanceof UserInGroupFilter) {
            this.addParameter(sb, String.valueOf(type) + "Select", JiraFieldSpecialValue.ISSUE_SPECIFIC_GROUP.getClassic());
            this.addParameter(sb, type, ((UserInGroupFilter)filter).getGroup());
        }
    }

    private void addParameters(StringBuilder sb, String name, Collection<String> values) {
        for (String value : values) {
            this.addParameter(sb, name, value);
        }
    }

    private void addParameter(StringBuilder sb, String name, String value) {
        try {
            sb.append('&').append(name).append('=').append(URLEncoder.encode(value, this.encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addJqlInExpression(Collection<String> searchParams, String key, Collection<String> values) {
        if (values.size() == 0) {
            return;
        }
        StringBuilder param = new StringBuilder();
        param.append(key);
        param.append(" in (");
        param.append(StringUtils.join(values, (String)","));
        param.append(")");
        searchParams.add(param.toString());
    }

    private void addJqlOrExpression(Collection<String> searchParams, Collection<String> expressions) {
        if (expressions.size() > 0) {
            searchParams.add("(" + StringUtils.join(expressions, (String)" OR ") + ")");
        }
    }

    private void addJqlAndExpression(Collection<String> searchParams, String field, Collection<String> operatorAndValue) {
        if (operatorAndValue.size() > 0) {
            StringBuilder buffer = new StringBuilder("(");
            Iterator<String> valueIter = operatorAndValue.iterator();
            while (valueIter.hasNext()) {
                buffer.append(field);
                buffer.append(" ");
                buffer.append(valueIter.next());
                if (!valueIter.hasNext()) continue;
                buffer.append(" AND ");
            }
            buffer.append(")");
            searchParams.add(buffer.toString());
        }
    }
}

