/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.web.rss;

import com.atlassian.connector.eclipse.internal.jira.core.model.NamedFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDefinition;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueCollector;
import com.atlassian.connector.eclipse.internal.jira.core.service.FilterDefinitionConverter;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.JiraWebSession;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.JiraWebSessionCallback;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.rss.JiraRssSessionCallback;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IProgressMonitor;

public class JiraRssClient {
    private final JiraClient client;
    private final JiraWebSession session;

    public JiraRssClient(JiraClient client, JiraWebSession session) {
        this.client = client;
        this.session = session;
    }

    private void doInSession(IProgressMonitor monitor, JiraWebSessionCallback callback) throws JiraException {
        this.session.doInSession(callback, monitor);
    }

    public void executeNamedFilter(final NamedFilter filter, final IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraRssSessionCallback(this.client.isCompressionEnabled(), collector){

            @Override
            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/sr/jira.issueviews:searchrequest-xml/").append(filter.getId()).append("/SearchRequest-").append(filter.getId()).append(".xml");
                if (collector.getMaxHits() != -1) {
                    rssUrlBuffer.append("?tempMax=").append(collector.getMaxHits());
                }
                return rssUrlBuffer.toString();
            }
        });
    }

    public void findIssues(final FilterDefinition filterDefinition, final IssueCollector collector, final IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraRssSessionCallback(this.client.isCompressionEnabled(), collector){

            @Override
            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?decorator=none&reset=true&");
                if (collector.getMaxHits() != -1) {
                    rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                }
                FilterDefinitionConverter filterConverter = new FilterDefinitionConverter(JiraRssClient.this.client.getCharacterEncoding(monitor), JiraRssClient.this.client.getLocalConfiguration().getDateFormat());
                rssUrlBuffer.append(filterConverter.getQueryParams(filterDefinition));
                return rssUrlBuffer.toString();
            }
        });
    }

    public void getIssueByKey(final String issueKey, IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraRssSessionCallback(this.client.isCompressionEnabled(), collector){

            @Override
            protected String getRssUrl(String baseUrl) throws JiraException {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/si/jira.issueviews:issue-xml/");
                rssUrlBuffer.append(issueKey);
                rssUrlBuffer.append("/");
                rssUrlBuffer.append(issueKey);
                rssUrlBuffer.append(".xml");
                return rssUrlBuffer.toString();
            }
        });
    }

    public void quickSearch(final String searchString, final IssueCollector collector, IProgressMonitor monitor) throws JiraException {
        this.doInSession(monitor, new JiraRssSessionCallback(this.client.isCompressionEnabled(), collector){

            @Override
            protected String getRssUrl(String baseUrl) {
                StringBuilder rssUrlBuffer = new StringBuilder(baseUrl);
                rssUrlBuffer.append("/secure/QuickSearch.jspa?view=rss&decorator=none&reset=true&");
                if (collector.getMaxHits() != -1) {
                    rssUrlBuffer.append("tempMax=").append(collector.getMaxHits()).append('&');
                }
                try {
                    rssUrlBuffer.append("searchString=").append(URLEncoder.encode(searchString, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unexpected error encoding search query", e);
                }
                return rssUrlBuffer.toString();
            }
        });
    }
}

