/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.store;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import rabbit.data.internal.xml.DatatypeUtil;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.convert.IConverter;
import rabbit.data.internal.xml.merge.IMerger;
import rabbit.data.internal.xml.merge.Mergers;
import rabbit.data.internal.xml.schema.events.EventGroupType;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.data.internal.xml.schema.events.ObjectFactory;
import rabbit.data.store.IStorer;
import rabbit.data.store.model.DiscreteEvent;
import rabbit.tracking.internal.TrackingPlugin;

public abstract class AbstractStorer<E extends DiscreteEvent, T, S extends EventGroupType>
implements IStorer<E> {
    protected final ObjectFactory objectFactory;
    private final Set<S> data;
    private LocalDate currentMonth;
    private final IConverter<E, T> converter;
    private final IMerger<T> merger;
    private final IDataStore store;

    protected AbstractStorer(IConverter<E, T> converter, IMerger<T> merger, IDataStore store) {
        this.converter = (IConverter)Preconditions.checkNotNull(converter);
        this.merger = (IMerger)Preconditions.checkNotNull(merger);
        this.store = (IDataStore)Preconditions.checkNotNull((Object)store);
        this.data = new LinkedHashSet<S>();
        this.currentMonth = new LocalDate();
        this.objectFactory = new ObjectFactory();
    }

    @Override
    public void commit() {
        if (this.data.isEmpty()) {
            return;
        }
        File f = this.getDataStore().getDataFile(null);
        EventListType events = this.getDataStore().read(f);
        List<S> categories = this.getCategories(events);
        IMerger<T> merger = this.getMerger();
        for (EventGroupType mergeFrom : this.data) {
            boolean done = false;
            for (EventGroupType mergeTo : categories) {
                if (!mergeFrom.getDate().equals(mergeTo.getDate())) continue;
                if (merger != null) {
                    Mergers.merge(merger, this.getElements(mergeTo), this.getElements(mergeFrom));
                } else {
                    this.getElements(mergeTo).addAll(this.getElements(mergeFrom));
                }
                done = true;
                break;
            }
            if (done) continue;
            categories.add(mergeFrom);
        }
        if (!this.getDataStore().write(events, f)) {
            TrackingPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.openedge.pdt.analytics", "Unable to save data."));
        }
        this.data.clear();
    }

    @Override
    public void insert(Collection<? extends E> collection) {
        for (DiscreteEvent elements : collection) {
            this.insert((E)elements);
        }
    }

    @Override
    public void insert(E event) {
        EventGroupType category2;
        DateTime time = ((DiscreteEvent)event).getTime();
        if (!DatatypeUtil.isSameMonthInYear(((DiscreteEvent)event).getTime(), this.currentMonth)) {
            this.commit();
            this.currentMonth = time.toLocalDate();
        }
        IMerger<T> merger = this.getMerger();
        T element = this.getConverter().convert(event);
        for (EventGroupType category2 : this.data) {
            if (!DatatypeUtil.isSameDate(((DiscreteEvent)event).getTime(), category2.getDate())) continue;
            if (merger != null) {
                Mergers.merge(merger, this.getElements(category2), element);
            } else {
                this.getElements(category2).add(element);
            }
            return;
        }
        category2 = this.newCategory(DatatypeUtil.toXmlDate(((DiscreteEvent)event).getTime()));
        this.getElements(category2).add(element);
        this.data.add(category2);
    }

    protected abstract List<S> getCategories(EventListType var1);

    protected final IConverter<E, T> getConverter() {
        return this.converter;
    }

    protected final IDataStore getDataStore() {
        return this.store;
    }

    protected abstract List<T> getElements(S var1);

    protected final IMerger<T> getMerger() {
        return this.merger;
    }

    protected abstract S newCategory(XMLGregorianCalendar var1);
}

