/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal;

import java.util.Observable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import rabbit.tracking.internal.TrackingPlugin;

public final class IdleDetector
extends Observable
implements Listener {
    private ScheduledThreadPoolExecutor timer;
    private ScheduledFuture<?> currentTask;
    private final Display display;
    private boolean isRunning;
    private boolean isActive;
    private long lastEventNanoTime;
    private final long idleIntervalMillis;
    private final long runDelayMillis;
    private TrackingPlugin plugin;
    private final Runnable taskCode = new Runnable(){

        @Override
        public void run() {
            if (!IdleDetector.this.isActive) {
                return;
            }
            long durationMillis = TimeUnit.NANOSECONDS.toMillis(IdleDetector.this.nowNanoTime() - IdleDetector.this.lastEventNanoTime);
            if (durationMillis > IdleDetector.this.idleIntervalMillis) {
                IdleDetector.this.isActive = false;
                IdleDetector.this.plugin = TrackingPlugin.getDefault();
                IdleDetector.this.plugin.saveCurrentData();
                IdleDetector.this.setChanged();
                IdleDetector.this.notifyObservers();
                TrackingPlugin.pushToTelerik();
            }
        }
    };
    private final Runnable addFilters = new Runnable(){

        @Override
        public void run() {
            IdleDetector.this.display.addFilter(1, (Listener)IdleDetector.this);
            IdleDetector.this.display.addFilter(3, (Listener)IdleDetector.this);
        }
    };
    private final Runnable removeFilters = new Runnable(){

        @Override
        public void run() {
            IdleDetector.this.display.removeFilter(1, (Listener)IdleDetector.this);
            IdleDetector.this.display.removeFilter(3, (Listener)IdleDetector.this);
        }
    };

    public IdleDetector(Display disp, long idleTime, long delay) {
        if (disp == null) {
            throw new NullPointerException();
        }
        if (idleTime < 0L || delay < 0L) {
            throw new IllegalArgumentException();
        }
        this.isRunning = false;
        this.isActive = false;
        this.runDelayMillis = delay;
        this.idleIntervalMillis = idleTime;
        this.display = disp;
    }

    public Display getDisplay() {
        return this.display;
    }

    public long getIdleInterval() {
        return this.idleIntervalMillis;
    }

    public long getRunDelay() {
        return this.runDelayMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        IdleDetector idleDetector = this;
        synchronized (idleDetector) {
            this.lastEventNanoTime = this.nowNanoTime();
            if (this.isActive) {
                return;
            }
            this.isActive = true;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized boolean isUserActive() {
        if (!this.isRunning) {
            return true;
        }
        return this.isActive;
    }

    public synchronized void setRunning(boolean run) {
        if (this.isRunning == run || this.display.isDisposed()) {
            return;
        }
        if (run) {
            this.isRunning = true;
            this.isActive = true;
            this.lastEventNanoTime = this.nowNanoTime();
            this.display.syncExec(this.addFilters);
            this.timer = new ScheduledThreadPoolExecutor(1);
            this.currentTask = this.timer.scheduleWithFixedDelay(this.taskCode, this.runDelayMillis, this.runDelayMillis, TimeUnit.MILLISECONDS);
        } else {
            this.display.syncExec(this.removeFilters);
            this.currentTask.cancel(false);
            this.isRunning = false;
            this.isActive = false;
            this.timer.shutdownNow();
        }
    }

    private long nowNanoTime() {
        return System.nanoTime();
    }
}

