/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.trackers;

import com.google.common.collect.Maps;
import com.openedge.pdt.core.OECommonServicesPlugin;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.joda.time.Interval;
import rabbit.data.handler.DataHandler;
import rabbit.data.store.IStorer;
import rabbit.data.store.model.LaunchEvent;
import rabbit.tracking.internal.trackers.AbstractTracker;
import rabbit.tracking.internal.util.Recorder;

public class LaunchTracker
extends AbstractTracker<LaunchEvent> {
    private final IDebugEventSetListener listener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                LaunchTracker.this.handleDebugEvent(event);
                ++n2;
            }
        }
    };
    private final Observer observer = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            if (LaunchTracker.this.recorders.values().contains(o)) {
                Recorder recorder = (Recorder)o;
                long start = recorder.getLastRecord().getStartTimeMillis();
                long end = recorder.getLastRecord().getEndTimeMillis();
                ILaunch launch = (ILaunch)recorder.getLastRecord().getUserData();
                ILaunchConfiguration config = launch.getLaunchConfiguration();
                if (config == null) {
                    return;
                }
                ILaunchConfigurationType type = null;
                try {
                    type = config.getType();
                }
                catch (CoreException e) {
                    OECommonServicesPlugin.log((Throwable)e, (String)"com.openedge.pdt.analytics");
                    return;
                }
                Set<IPath> files = (Set<IPath>)LaunchTracker.this.launchFiles.get(launch);
                if (files == null) {
                    files = Collections.emptySet();
                }
                Interval interval = new Interval(start, end);
                LaunchTracker.this.addData(new LaunchEvent(interval, launch, config, type, files));
            }
        }
    };
    private final Map<ILaunch, Set<IPath>> launchFiles = Maps.newHashMap();
    private final Map<ILaunch, Recorder<ILaunch>> recorders = Maps.newHashMap();

    @Override
    protected IStorer<LaunchEvent> createDataStorer() {
        return DataHandler.getStorer(LaunchEvent.class);
    }

    @Override
    protected void doDisable() {
        DebugPlugin debug = DebugPlugin.getDefault();
        debug.removeDebugEventListener(this.listener);
    }

    @Override
    protected void doEnable() {
        DebugPlugin debug = DebugPlugin.getDefault();
        debug.addDebugEventListener(this.listener);
    }

    private void handleDebugEvent(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IProcess) {
            this.handleProcessEvent(event, (IProcess)source);
        } else if (source instanceof IThread) {
            this.handleThreadEvent(event, (IThread)source);
        }
    }

    private void handleProcessEvent(DebugEvent event, IProcess process) {
        Recorder<ILaunch> r;
        ILaunch launch = process.getLaunch();
        if (event.getKind() == 4) {
            Recorder<Object> r2 = this.recorders.get(launch);
            if (r2 == null) {
                r2 = new Recorder();
                r2.addObserver(this.observer);
                this.recorders.put(launch, r2);
            }
            r2.start(launch);
        } else if (event.getKind() == 8 && (r = this.recorders.get(launch)) != null) {
            r.stop();
        }
    }

    private void handleThreadEvent(DebugEvent event, IThread thread) {
        if (event.getKind() != 2) {
            return;
        }
        ILaunch launch = thread.getLaunch();
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return;
        }
        IStackFrame stack = null;
        try {
            stack = thread.getTopStackFrame();
        }
        catch (DebugException debugException) {
            return;
        }
        if (stack == null) {
            return;
        }
        ISourceLocator sourceLocator = launch.getSourceLocator();
        if (sourceLocator == null) {
            return;
        }
        Object element = sourceLocator.getSourceElement(stack);
        if (element != null && element instanceof IFile) {
            IFile file = (IFile)element;
            Set<IPath> filePaths = this.launchFiles.get(launch);
            if (filePaths == null) {
                filePaths = new HashSet<IPath>(3);
                this.launchFiles.put(launch, filePaths);
            }
            filePaths.add(file.getFullPath());
        }
    }
}

