/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.trackers;

import java.util.Observable;
import java.util.Observer;
import javax.annotation.Nullable;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.joda.time.Interval;
import rabbit.data.handler.DataHandler;
import rabbit.data.store.IStorer;
import rabbit.data.store.model.PerspectiveEvent;
import rabbit.tracking.internal.IdleDetector;
import rabbit.tracking.internal.TrackingPlugin;
import rabbit.tracking.internal.trackers.AbstractTracker;
import rabbit.tracking.internal.util.Recorder;
import rabbit.tracking.internal.util.WorkbenchUtil;

public class PerspectiveTracker
extends AbstractTracker<PerspectiveEvent> {
    private final Recorder<IPerspectiveDescriptor> recorder = new Recorder();
    private final Observer observer = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            if (!PerspectiveTracker.this.isEnabled()) {
                return;
            }
            if (o == TrackingPlugin.getDefault().getIdleDetector()) {
                if (((IdleDetector)o).isUserActive()) {
                    PerspectiveTracker.this.checkStart();
                } else {
                    PerspectiveTracker.this.recorder.stop();
                }
            } else if (o == PerspectiveTracker.this.recorder) {
                long start = PerspectiveTracker.this.recorder.getLastRecord().getStartTimeMillis();
                long end = PerspectiveTracker.this.recorder.getLastRecord().getEndTimeMillis();
                IPerspectiveDescriptor p = (IPerspectiveDescriptor)PerspectiveTracker.this.recorder.getLastRecord().getUserData();
                PerspectiveTracker.this.addData(new PerspectiveEvent(new Interval(start, end), p));
            }
        }
    };
    private final IPerspectiveListener persplistener = new PerspectiveAdapter(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveTracker.this.recorder.start(perspective);
        }

        public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveTracker.this.recorder.stop();
        }
    };
    private final IWindowListener winlistener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow win) {
            PerspectiveTracker.this.recorder.start(WorkbenchUtil.getPerspective(win));
        }

        public void windowClosed(IWorkbenchWindow win) {
            win.removePerspectiveListener(PerspectiveTracker.this.persplistener);
            PerspectiveTracker.this.recorder.stop();
        }

        public void windowDeactivated(IWorkbenchWindow win) {
            PerspectiveTracker.this.recorder.stop();
        }

        public void windowOpened(IWorkbenchWindow win) {
            win.addPerspectiveListener(PerspectiveTracker.this.persplistener);
            if (WorkbenchUtil.isActiveShell(win)) {
                PerspectiveTracker.this.checkStart(win);
            }
        }
    };

    public PerspectiveTracker() {
        this.recorder.addObserver(this.observer);
    }

    @Override
    protected IStorer<PerspectiveEvent> createDataStorer() {
        return DataHandler.getStorer(PerspectiveEvent.class);
    }

    @Override
    protected void doDisable() {
        this.recorder.stop();
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow win = iWorkbenchWindowArray[n2];
            win.removePerspectiveListener(this.persplistener);
            ++n2;
        }
        TrackingPlugin.getDefault().getIdleDetector().deleteObserver(this.observer);
        PlatformUI.getWorkbench().removeWindowListener(this.winlistener);
    }

    @Override
    protected void doEnable() {
        this.checkStart();
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow win = iWorkbenchWindowArray[n2];
            win.addPerspectiveListener(this.persplistener);
            ++n2;
        }
        TrackingPlugin.getDefault().getIdleDetector().addObserver(this.observer);
        PlatformUI.getWorkbench().addWindowListener(this.winlistener);
    }

    private void checkStart() {
        IWorkbenchWindow win = WorkbenchUtil.getActiveWindow();
        if (WorkbenchUtil.isActiveShell(win)) {
            this.checkStart(win);
        }
    }

    private void checkStart(@Nullable IWorkbenchWindow activeWin) {
        IPerspectiveDescriptor p = WorkbenchUtil.getPerspective(activeWin);
        if (p != null) {
            this.recorder.start(p);
        }
    }

    private IWorkbenchWindow[] getWorkbenchWindows() {
        return PlatformUI.getWorkbench().getWorkbenchWindows();
    }
}

