/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.merge;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import rabbit.data.internal.xml.merge.IMerger;

public class Mergers {
    public static <T> Collection<T> merge(@Nullable IMerger<T> merger, Collection<T> to, Collection<T> from) {
        Preconditions.checkNotNull(to);
        Preconditions.checkNotNull(from);
        if (merger == null) {
            to.addAll(from);
            return to;
        }
        for (T element : from) {
            Mergers.merge(merger, to, element);
        }
        return to;
    }

    public static <T> Collection<T> merge(@Nullable IMerger<T> merger, Collection<T> collection, T item) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(item);
        if (merger == null) {
            collection.add(item);
            return collection;
        }
        Object mergedElement = null;
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            T element = it.next();
            if (!merger.isMergeable(element, item)) continue;
            mergedElement = merger.merge(element, item);
            it.remove();
            break;
        }
        if (mergedElement == null) {
            collection.add(item);
        } else {
            collection.add(mergedElement);
        }
        return collection;
    }
}

