/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Observable;
import javax.annotation.Nullable;

public final class Recorder<T>
extends Observable {
    private long start;
    private T data;
    private Record<T> record;
    private boolean running;

    public synchronized T getUserData() {
        return this.data;
    }

    public synchronized void start(@Nullable T userData) {
        if (this.isRecording()) {
            if (!Objects.equal(this.data, userData)) {
                this.stop();
            } else {
                return;
            }
        }
        this.start = System.currentTimeMillis();
        this.data = userData;
        this.running = true;
    }

    public synchronized void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Record<T> r = null;
        Recorder recorder = this;
        synchronized (recorder) {
            if (!this.isRecording()) {
                return;
            }
            r = this.record = new Record<T>(this.start, System.currentTimeMillis(), this.data);
            this.running = false;
            this.data = null;
        }
        this.setChanged();
        this.notifyObservers(r);
    }

    public synchronized boolean isRecording() {
        return this.running;
    }

    public synchronized Record<T> getLastRecord() {
        return this.record;
    }

    public static final class Record<T> {
        private final long startTimeMillis;
        private final long endTimeMillis;
        private final T userData;

        public Record(long startMillis, long endMillis, @Nullable T data) {
            Preconditions.checkArgument((endMillis >= startMillis ? 1 : 0) != 0);
            this.startTimeMillis = startMillis;
            this.endTimeMillis = endMillis;
            this.userData = data;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        public long getEndTimeMillis() {
            return this.endTimeMillis;
        }

        public T getUserData() {
            return this.userData;
        }
    }
}

