/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.access;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.IFileData;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.FileData;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.access.AbstractAccessor;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.data.internal.xml.schema.events.FileEventListType;
import rabbit.data.internal.xml.schema.events.FileEventType;

public class FileDataAccessor
extends AbstractAccessor<IFileData, FileEventType, FileEventListType> {
    @Inject
    FileDataAccessor(@Named(value="FileStore") IDataStore store) {
        super(store);
    }

    @Override
    protected IFileData createDataNode(LocalDate date, WorkspaceStorage ws, FileEventType type) throws Exception {
        return new FileData(date, ws, new Duration(type.getDuration()), this.workspaceRoot().getFile((IPath)new Path(type.getFileType())));
    }

    @Override
    protected Collection<FileEventType> getElements(FileEventListType list) {
        return list.getFileEvent();
    }

    @Override
    protected Collection<FileEventListType> getCategories(EventListType doc) {
        return doc.getFileEvents();
    }

    private IWorkspaceRoot workspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

