/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.trackers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.joda.time.DateTime;
import rabbit.data.handler.DataHandler;
import rabbit.data.store.IStorer;
import rabbit.data.store.model.CommandEvent;
import rabbit.tracking.internal.trackers.AbstractTracker;

public class CommandTracker
extends AbstractTracker<CommandEvent>
implements IExecutionListener {
    private ExecutionEvent lastEvent = null;

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException e) {
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
        if (this.lastEvent != null && this.lastEvent.getCommand().getId().equals(commandId)) {
            this.addData(new CommandEvent(new DateTime(), this.lastEvent));
        }
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        this.lastEvent = event;
    }

    @Override
    protected IStorer<CommandEvent> createDataStorer() {
        return DataHandler.getStorer(CommandEvent.class);
    }

    @Override
    protected void doDisable() {
        this.getCommandService().removeExecutionListener((IExecutionListener)this);
    }

    @Override
    protected void doEnable() {
        this.getCommandService().addExecutionListener((IExecutionListener)this);
    }

    private ICommandService getCommandService() {
        return (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
    }
}

