/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.PaGit;
import com.proalpha.git.model.PaCherryPickResult;
import com.proalpha.git.util.PaCommitMsg;
import com.proalpha.pds.gitutils.cherrypick.CherryPick;
import com.proalpha.pds.gitutils.cherrypick.CherryPickOperation;
import com.proalpha.pds.gitutils.cherrypick.CherryPickResultDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CherryPickJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(CherryPickJob.class);

    public CherryPickJob(String name) {
        super(name);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            CherryPickOperation op = new CherryPickOperation(CherryPick.getInstance().getCherryPickCommand());
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"pA CherryPick", (int)3);
            progress.worked(1);
            PaGit.getInstance().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(1)));
            op.execute();
            CherryPick.getInstance().setCherryPickResult(op.getOperationResult());
            RevCommit newHead = CherryPick.getInstance().getCherryPickResult().getNewHead();
            if (newHead != null) {
                CherryPickResult.CherryPickStatus status = CherryPick.getInstance().getCherryPickResult().getStatus();
                switch (status) {
                    case CONFLICTING: {
                        break;
                    }
                    case FAILED: {
                        break;
                    }
                }
                if (status != CherryPickResult.CherryPickStatus.OK) {
                    this.setConflictMessage();
                }
                this.showResultDialog(CherryPick.getInstance().getCherryPickResult());
            }
        }
        catch (InvocationTargetException e) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)e.getCause().getMessage(), (String)e.getCause().getLocalizedMessage());
                }
            });
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.CHERRY_PICK.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private void setConflictMessage() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                StagingView view = (StagingView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.egit.ui.StagingView");
                CherryPickJob.this.logger.debug("Commit failed: Initialize the commit msg of the git staging view.");
                if (view != null) {
                    String msg = PaCommitMsg.getCherryPickMsg((String)((RevCommit)CherryPick.getInstance().getCherryPickResult().getOpenPicks().get(0)).getFullMessage(), (String)((RevCommit)CherryPick.getInstance().getCherryPickResult().getOpenPicks().get(0)).getId().name());
                    msg = String.valueOf(msg) + System.getProperty("line.separator");
                    msg = String.valueOf(msg) + System.getProperty("line.separator");
                    msg = String.valueOf(msg) + "Conflict resolution: DO NOT EDIT THIS MESSAGE";
                    view.setCommitMessage(msg);
                    view.setFocus();
                }
            }
        });
    }

    private void showResultDialog(final PaCherryPickResult cherryPickResult) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                new CherryPickResultDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), cherryPickResult).open();
            }
        });
    }
}

