/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.search;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.search.GitGrepSearchQuery;
import com.proalpha.pds.gitutils.search.GitGrepSearchSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GitGrepSearchPage
extends DialogPage
implements ISearchPage {
    private static final String PAGE_NAME = "pAGitGrepSearchPage";
    private static final String HISTORY_STORE = "HISTORY";
    private static final int HISTORY_SIZE = 10;
    private Text txtMatchesFile;
    private Text txtMaxFinds;
    private Button btnCaseSensitive;
    private Combo cmbObjectType;
    private Group repositoryGroup;
    private CheckboxTableViewer repositoryViewer;
    private ISearchPageContainer container;
    private List<GitGrepSearchSettings> savedSettings = new ArrayList<GitGrepSearchSettings>(10);
    private Combo cmbSearchPhrase;

    public void createControl(Composite parent) {
        this.loadSettings();
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        Label lblContainingText = new Label(main, 0);
        lblContainingText.setText("Containing text:");
        new Label(main, 0);
        this.cmbSearchPhrase = new Combo(main, 2052);
        GridData gd_cmbSearchPhrase = new GridData(4, 4, true, false, 1, 1);
        gd_cmbSearchPhrase.widthHint = this.convertWidthInCharsToPixels(10);
        this.cmbSearchPhrase.setLayoutData((Object)gd_cmbSearchPhrase);
        this.cmbSearchPhrase.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GitGrepSearchPage.this.checkOK();
            }
        });
        this.btnCaseSensitive = new Button(main, 32);
        this.btnCaseSensitive.setText("Case sensitive");
        Label lblHint = new Label(main, 0);
        lblHint.setText("(* = any string, ? = any character, \\\\ = escape for literals: * ? \\\\)");
        new Label(main, 0);
        Group grpScope = new Group(main, 0);
        GridData gd_grpScope = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_grpScope.heightHint = 77;
        gd_grpScope.widthHint = 475;
        grpScope.setLayoutData((Object)gd_grpScope);
        grpScope.setText("Scope");
        Label lblMatchesFile = new Label((Composite)grpScope, 0);
        lblMatchesFile.setBounds(10, 18, 122, 15);
        lblMatchesFile.setText("Objectname (can-do):");
        this.txtMatchesFile = new Text((Composite)grpScope, 2048);
        this.txtMatchesFile.setBounds(139, 15, 150, 21);
        Label lblObjecttype = new Label((Composite)grpScope, 0);
        lblObjecttype.setBounds(10, 44, 70, 15);
        lblObjecttype.setText("Objecttype:");
        this.cmbObjectType = new Combo((Composite)grpScope, 0);
        this.cmbObjectType.setItems(new String[]{"ALL", "PDI", "SRC", "SRC_PDI"});
        this.cmbObjectType.setBounds(139, 41, 60, 23);
        this.cmbObjectType.setText("SRC");
        Label lblMaxfinds = new Label((Composite)grpScope, 0);
        lblMaxfinds.setBounds(10, 70, 55, 15);
        lblMaxfinds.setText("Maxfinds:");
        this.txtMaxFinds = new Text((Composite)grpScope, 2048);
        this.txtMaxFinds.setBounds(139, 67, 40, 21);
        this.txtMaxFinds.setText("100");
        new Label(main, 0);
        this.repositoryGroup = new Group(main, 0);
        this.repositoryGroup.setBackgroundMode(1);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.repositoryGroup);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this.repositoryGroup);
        this.repositoryViewer = CheckboxTableViewer.newCheckList((Composite)this.repositoryGroup, (int)2820);
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new RepositoriesViewLabelProvider()));
        this.repositoryViewer.setContentProvider((IContentProvider)new RepositoriesViewContentProvider());
        this.repositoryViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.repositoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GitGrepSearchPage.this.repositoryViewer.setAllChecked(false);
                GitGrepSearchPage.this.repositoryViewer.setChecked(event.getElement(), true);
                GitGrepSearchPage.this.checkOK();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 40).applyTo(this.repositoryViewer.getControl());
        this.repositoryGroup.setText("Repositories:");
        this.setControl((Control)main);
        Dialog.applyDialogFont((Control)main);
    }

    public boolean performAction() {
        GitGrepSearchSettings searchSettings = new GitGrepSearchSettings();
        if (this.txtMatchesFile.getText().length() > 0) {
            searchSettings.setFileNamePhrase(this.txtMatchesFile.getText());
        }
        searchSettings.setTextPhrase(this.cmbSearchPhrase.getText());
        searchSettings.setFileType(this.cmbObjectType.getText());
        searchSettings.setCaseSensitive(this.btnCaseSensitive.getSelection());
        searchSettings.setMaxFinds(Integer.parseInt(this.txtMaxFinds.getText()));
        this.savedSettings.add(0, searchSettings);
        Object[] objectArray = this.repositoryViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            try {
                searchSettings.setRepositoryPath(((RepositoryNode)checkedElement).getRepository().getDirectory().getAbsolutePath());
                searchSettings.setBranchName(((RepositoryNode)checkedElement).getRepository().getBranch());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        GitGrepSearchQuery newQuery = new GitGrepSearchQuery(searchSettings);
        NewSearchUI.runQueryInBackground((ISearchQuery)newQuery);
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    private ISearchPageContainer getContainer() {
        return this.container;
    }

    public void dispose() {
        this.storeSettings();
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.cmbSearchPhrase.setItems(this.getSavedSearchPhrases());
            this.txtMatchesFile.setText(this.savedSettings.get(0).getFileNamePhrase());
            this.txtMaxFinds.setText(Integer.toString(this.savedSettings.get(0).getMaxFinds()));
            this.btnCaseSensitive.setSelection(this.savedSettings.get(0).isCaseSensitive());
            this.cmbObjectType.setText(this.savedSettings.get(0).getFileType());
            File file = new File(this.savedSettings.get(0).getRepositoryPath());
            if (file.exists()) {
                try {
                    RepositoryNode node = new RepositoryNode(null, org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().lookupRepository(file));
                    this.repositoryViewer.setChecked((Object)node, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        super.setVisible(visible);
    }

    private String[] getSavedSearchPhrases() {
        int size = this.savedSettings.size();
        String[] testPhrases = new String[size];
        int iCount = 0;
        while (iCount < size) {
            testPhrases[iCount] = this.savedSettings.get(iCount).getTextPhrase();
            ++iCount;
        }
        return testPhrases;
    }

    private void checkOK() {
        boolean isOk = false;
        if (this.cmbSearchPhrase.getText().length() > 0 && this.repositoryViewer.getCheckedElements().length > 0) {
            isOk = true;
        }
        this.getContainer().setPerformActionEnabled(isOk);
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
        if (section == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        return section;
    }

    private void storeSettings() {
        int minSize = Math.min(this.savedSettings.size(), 10);
        IDialogSettings ds = this.getDialogSettings();
        ds.put("HISTORY_SIZE", minSize);
        int iCount = 0;
        while (iCount < minSize) {
            this.savedSettings.get(iCount).save(ds.addNewSection(HISTORY_STORE + iCount));
            ++iCount;
        }
    }

    private void loadSettings() {
        IDialogSettings ds = this.getDialogSettings();
        try {
            int histSize = ds.getInt("HISTORY_SIZE");
            int iCount = 0;
            while (iCount < histSize) {
                IDialogSettings histSettings = ds.getSection(HISTORY_STORE + iCount);
                if (histSettings != null) {
                    this.savedSettings.add(GitGrepSearchSettings.load(histSettings));
                }
                ++iCount;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

