/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.model.gitblit.GitBlitRepository;
import com.proalpha.git.util.gitblit.GitBlitRpcCallGetRepoList;
import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.cherrypick.CherryPickWizard;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.framework.Bundle;

public class CherryPickPage
extends WizardPage {
    private Repository srcRepository;
    private List<GitBlitRepository> currRepos;
    private Combo txtSrcRepository;
    private Combo txtSrcBranch;
    private Text txtSrcFeature;
    private Text txtTargetRepository;
    private Text txtTargetBranch;
    private Button btnFetchCommits;

    public CherryPickPage(Repository repository) {
        super(CherryPickPage.class.getName());
        this.srcRepository = repository;
        this.setTitle("proALPHA CherryPick");
        this.setMessage("Select Repository and Branch which needs to get picked into your current repository", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public void createControl(Composite parent) {
        GitBlitRpcCallGetRepoList rpc = new GitBlitRpcCallGetRepoList(Activator.getDefault().getPreferenceStore().getString("PaGitBlitServerUrl"));
        rpc.execute();
        this.currRepos = (List)rpc.getRpcResponse();
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Group grpSource = new Group(container, 0);
        GridData gd_grpSource = new GridData(0x1000000, 128, true, false, 1, 1);
        gd_grpSource.heightHint = 85;
        gd_grpSource.widthHint = 450;
        grpSource.setLayoutData((Object)gd_grpSource);
        grpSource.setText("Source");
        Label lblRepository = new Label((Composite)grpSource, 0);
        lblRepository.setText("Repository:");
        lblRepository.setBounds(10, 22, 80, 15);
        Label lblBranch = new Label((Composite)grpSource, 0);
        lblBranch.setText("Branch:");
        lblBranch.setBounds(10, 49, 80, 15);
        Label lblFeature = new Label((Composite)grpSource, 0);
        lblFeature.setText("Feature:");
        lblFeature.setBounds(10, 76, 80, 15);
        this.txtSrcRepository = new Combo((Composite)grpSource, 2048);
        this.txtSrcRepository.setBounds(96, 19, 212, 21);
        this.txtSrcRepository.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CherryPickPage.this.checkRepoAndProposeBranches();
            }
        });
        this.txtSrcRepository.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose your source repository");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.txtSrcBranch.getText().length() != 0) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        this.txtSrcBranch = new Combo((Composite)grpSource, 2048);
        this.txtSrcBranch.setBounds(96, 46, 212, 21);
        this.txtSrcBranch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CherryPickPage.this.txtSrcBranch.getText().length() != 0 && CherryPickPage.this.checkBranch()) {
                    CherryPickPage.this.setFeatureText(CherryPickPage.this.txtSrcBranch.getText());
                }
            }
        });
        this.txtSrcBranch.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose your source branch");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.txtSrcBranch.getText().length() != 0 && CherryPickPage.this.checkBranch()) {
                    CherryPickPage.this.setFeatureText(CherryPickPage.this.txtSrcBranch.getText());
                }
            }
        });
        String[] repos = new String[this.currRepos.size()];
        int i = 0;
        while (i < this.currRepos.size()) {
            repos[i] = this.currRepos.get(i).getName();
            ++i;
        }
        this.txtSrcRepository.setItems(repos);
        this.txtSrcFeature = new Text((Composite)grpSource, 2048);
        this.txtSrcFeature.setBounds(96, 73, 162, 21);
        this.txtSrcFeature.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CherryPickPage.this.txtSrcBranch.getText().length() != 0) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        this.txtSrcFeature.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Type your feature to pick");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.txtSrcBranch.getText().length() != 0 && CherryPickPage.this.txtSrcFeature.getText().length() != 0) {
                    CherryPickPage.this.btnFetchCommits.setEnabled(true);
                }
            }
        });
        Button btnRefreshRepos = new Button((Composite)grpSource, 0);
        btnRefreshRepos.setToolTipText("Reload repositories from server");
        btnRefreshRepos.setImage(ResourceManager.getPluginImage("com.proalpha.pds.gitutils", "icons/refresh.gif"));
        btnRefreshRepos.setBounds(314, 18, 28, 23);
        this.setControl((Control)container);
        Group grpTarget = new Group(container, 0);
        GridData gd_grpTarget = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_grpTarget.widthHint = 450;
        gd_grpTarget.heightHint = 60;
        grpTarget.setLayoutData((Object)gd_grpTarget);
        grpTarget.setText("Target");
        Label label = new Label((Composite)grpTarget, 0);
        label.setText("Repository:");
        label.setBounds(10, 23, 80, 15);
        Label label_1 = new Label((Composite)grpTarget, 0);
        label_1.setText("Branch:");
        label_1.setBounds(10, 50, 80, 15);
        this.txtTargetRepository = new Text((Composite)grpTarget, 0);
        this.txtTargetRepository.setBounds(96, 20, 212, 21);
        this.txtTargetRepository.setText(this.srcRepository.getDirectory().toString());
        this.txtTargetRepository.setEnabled(false);
        this.txtTargetBranch = new Text((Composite)grpTarget, 2048);
        this.txtTargetBranch.setBounds(96, 47, 212, 21);
        this.txtTargetBranch.setEnabled(false);
        this.txtTargetBranch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CherryPickPage.this.txtTargetBranch.getText().length() != 0) {
                    IWizard wiz = CherryPickPage.this.getWizard();
                    ((CherryPickWizard)wiz).setTargetBranch(CherryPickPage.this.txtTargetBranch.getText());
                }
            }
        });
        final Button btnEditBranchname = new Button((Composite)grpTarget, 32);
        btnEditBranchname.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.txtTargetBranch.setEnabled(btnEditBranchname.getSelection());
                if (!btnEditBranchname.getSelection()) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        btnEditBranchname.setBounds(314, 49, 129, 16);
        btnEditBranchname.setText("modify Branchname");
        new Label(container, 0);
        this.btnFetchCommits = new Button(container, 0);
        this.btnFetchCommits.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnFetchCommits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWizard wiz = CherryPickPage.this.getWizard();
                ((CherryPickWizard)wiz).setSourceIssue(CherryPickPage.this.txtSrcFeature.getText());
                ((CherryPickWizard)wiz).setSourceBranch(CherryPickPage.this.txtSrcBranch.getText());
                ((CherryPickWizard)wiz).setSourceRepoString(CherryPickPage.this.txtSrcRepository.getText());
                Boolean commitsfound = ((CherryPickWizard)wiz).gatherCommits();
                if (!commitsfound.booleanValue()) {
                    CherryPickPage.this.setMessage("No commits found!", 2);
                } else {
                    CherryPickPage.this.setMessage("Commits found! Push 'Next' to view or 'Finish' to pick them", 1);
                }
                CherryPickPage.this.setPageComplete(commitsfound);
            }
        });
        this.btnFetchCommits.setText("Fetch Commits");
        this.btnFetchCommits.setEnabled(false);
        this.setPageComplete(false);
    }

    private void setFeatureText(String branchText) {
        String issueKey = "";
        int separatorIdx = branchText.indexOf(46);
        while (separatorIdx > 0) {
            issueKey = branchText.substring(separatorIdx + 1, branchText.length());
            separatorIdx = branchText.indexOf(46, separatorIdx + 1);
        }
        if (issueKey.length() > 0) {
            this.txtSrcFeature.setText(issueKey);
        }
    }

    private boolean checkBranch() {
        String branchText = this.txtSrcBranch.getText();
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (branchText.length() == 0) {
            this.setPageComplete(false);
            return false;
        }
        boolean foundIt = false;
        for (GitBlitRepository actRepo : this.currRepos) {
            if (!actRepo.getName().equals(this.txtSrcRepository.getText())) continue;
            for (String actBranch : actRepo.getBranches()) {
                if (!actBranch.equals(branchText)) continue;
                foundIt = true;
            }
        }
        if (!foundIt) {
            this.setMessage("Branch not found!", 2);
            this.setPageComplete(false);
            this.btnFetchCommits.setEnabled(false);
            return false;
        }
        IWizard wiz = this.getWizard();
        ((CherryPickWizard)wiz).setSourceBranch(branchText);
        this.txtTargetBranch.setText(branchText);
        ((CherryPickWizard)wiz).setTargetBranch(branchText);
        this.btnFetchCommits.setEnabled(true);
        return true;
    }

    protected void checkRepoAndProposeBranches() {
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (this.txtSrcRepository.getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        boolean foundIt = false;
        for (GitBlitRepository actRepo : this.currRepos) {
            if (!actRepo.getName().equals(this.txtSrcRepository.getText())) continue;
            List actBranches = actRepo.getBranches();
            String[] branches = new String[actBranches.size()];
            int i = 0;
            while (i < actBranches.size()) {
                branches[i] = (String)actBranches.get(i);
                ++i;
            }
            this.txtSrcBranch.setItems(branches);
            foundIt = true;
        }
        if (!foundIt) {
            this.setMessage("Repository not found!", 2);
            this.setPageComplete(false);
            this.btnFetchCommits.setEnabled(false);
            this.txtSrcBranch.setItems(new String[0]);
            return;
        }
        IWizard wiz = this.getWizard();
        ((CherryPickWizard)wiz).setSourceRepoString(this.txtSrcRepository.getText());
    }
}

