/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.git.util.PaBranchName;
import com.proalpha.git.util.PaRepository;
import java.util.List;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.tasks.core.ITask;

public class FeatureBranchSettings {
    private ITask task;
    private Repository repository;
    private String targetBranch;
    private String sourceBranch;
    private boolean updateTargetBranch = true;
    private boolean updateSourceBranch = true;
    private boolean updateDbAndArtifacts = false;

    public boolean isUpdateDbAndArtifacts() {
        return this.updateDbAndArtifacts;
    }

    public void setUpdateDbAndArtifacts(boolean updateDbAndArtifacts) {
        this.updateDbAndArtifacts = updateDbAndArtifacts;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public boolean isUpdateTargetBranch() {
        return this.updateTargetBranch;
    }

    public void setUpdateTargetBranch(boolean updateTargetBranch) {
        this.updateTargetBranch = updateTargetBranch;
    }

    public boolean isUpdateSourceBranch() {
        return this.updateSourceBranch;
    }

    public void setUpdateSourceBranch(boolean updateSourceBranch) {
        this.updateSourceBranch = updateSourceBranch;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public void setTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public void setSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    public ITask getTask() {
        return this.task;
    }

    public void setTask(ITask task) {
        this.task = task;
    }

    public void deriveDefaults() {
        this.deriveDefaultSourceBranch();
        this.deriveDefaultTargetBranch();
    }

    public void deriveDefaultSourceBranch() {
        List branches = PaRepository.getMasterBranches((Repository)this.getRepository());
        if (!branches.isEmpty()) {
            String version = PaBranchName.getVersion((String)((String)branches.get(0)), (Repository)this.getRepository());
            if (version != null) {
                this.setSourceBranch(String.valueOf(version) + ".master");
                return;
            }
        } else {
            String version;
            branches = PaRepository.getCodeFreezeBranches((Repository)this.getRepository());
            if (!branches.isEmpty() && (version = PaBranchName.getVersion((String)((String)branches.get(0)), (Repository)this.getRepository())) != null) {
                this.setSourceBranch(version);
                return;
            }
        }
        this.setSourceBranch("master");
    }

    public void deriveDefaultTargetBranch() {
        String version = "";
        List branches = PaRepository.getMasterBranches((Repository)this.getRepository());
        if (branches.isEmpty()) {
            branches = PaRepository.getCodeFreezeBranches((Repository)this.getRepository());
        }
        if (!branches.isEmpty() && (version = PaBranchName.getVersion((String)((String)branches.get(0)), (Repository)this.getRepository())) != null) {
            this.setTargetBranch(String.valueOf(version) + "." + this.task.getTaskKey());
            return;
        }
        this.setTargetBranch(this.task.getTaskKey());
    }
}

