/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProjectPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.handlers.HandlerUtil;

public class RepositoryTools {
    private Repository repository;

    public RepositoryTools(Repository repository) {
        this.repository = repository;
    }

    public RepositoryTools(ExecutionEvent event) {
        RepositoryTreeNode treenode = null;
        try {
            treenode = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (treenode != null) {
            this.repository = treenode.getRepository();
        }
    }

    public List<?> getSelectedNodes(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    public List<String> getStagedFiles() {
        Status status = null;
        ArrayList<String> stagesFiles = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                status = git.status().call();
                for (String file : status.getChanged()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
                for (String file : status.getAdded()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
                for (String file : status.getRemoved()) {
                    if (file.contains("/")) {
                        stagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    stagesFiles.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            e.printStackTrace();
        }
        return stagesFiles;
    }

    public List<String> getUnstagedFiles() {
        Status status = null;
        ArrayList<String> unStagesFiles = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(this.repository);){
                status = git.status().call();
                for (String file : status.getUntracked()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getModified()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getConflicting()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
                for (String file : status.getMissing()) {
                    if (file.contains("/")) {
                        unStagesFiles.add(file.substring(file.lastIndexOf("/") + 1));
                        continue;
                    }
                    unStagesFiles.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            e.printStackTrace();
        }
        return unStagesFiles;
    }

    public IOpenEdgeProject getOpenEdgeProject() {
        long countSeparator = this.repository.getDirectory().getAbsolutePath().codePoints().filter(ch -> ch == System.getProperty("file.separator").toCharArray()[0]).count();
        String[] filePathArray = this.repository.getDirectory().getAbsolutePath().split(Matcher.quoteReplacement(System.getProperty("file.separator")));
        IProject project = null;
        project = countSeparator > 3L ? ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(filePathArray[filePathArray.length - 4]) + "-" + filePathArray[filePathArray.length - 3]) : ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(filePathArray[filePathArray.length - 2]) + "-" + filePathArray[filePathArray.length - 1]);
        IOpenEdgeProject oeProject = OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject(project);
        return oeProject;
    }
}

