/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import java.net.URL;
import java.text.DateFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.framework.Bundle;

public class CherryPickCommitPage
extends WizardPage {
    List<RevCommit> commitsfound;
    TreeViewer treeViewer;

    public CherryPickCommitPage() {
        super(CherryPickCommitPage.class.getName());
        this.setTitle("proALPHA CherryPick");
        this.setMessage("The following commits get picked into your Repository", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
        this.setDescription("Wizard Page description");
    }

    public void setCommitsfound(List<RevCommit> commitsfound) {
        this.commitsfound = commitsfound;
        this.treeViewer.setInput(commitsfound);
        this.treeViewer.refresh();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        this.treeViewer = new TreeViewer(container, 2048);
        Tree tree = this.treeViewer.getTree();
        tree.setBounds(0, 0, 574, 334);
        tree.setHeaderVisible(true);
        TreeViewerColumn treeViewerColumn_2 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnNewColumn_2 = treeViewerColumn_2.getColumn();
        trclmnNewColumn_2.setWidth(101);
        trclmnNewColumn_2.setText("CommitID");
        trclmnNewColumn_2.setAlignment(16384);
        treeViewerColumn_2.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new NameLabelProvider()));
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnNewColumn_1 = treeViewerColumn_1.getColumn();
        trclmnNewColumn_1.setWidth(200);
        trclmnNewColumn_1.setText("Message");
        trclmnNewColumn_1.setAlignment(16384);
        treeViewerColumn_1.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new MessageLabelProvider()));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnNewColumn = treeViewerColumn.getColumn();
        trclmnNewColumn.setWidth(100);
        trclmnNewColumn.setText("Author");
        trclmnNewColumn.setAlignment(16384);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AuthorLabelProvider()));
        TreeViewerColumn dateColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnDateColumn = dateColumn.getColumn();
        trclmnDateColumn.setWidth(100);
        trclmnDateColumn.setText("Date");
        trclmnDateColumn.setAlignment(16384);
        dateColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DateLabelProvider()));
        this.treeViewer.setContentProvider((IContentProvider)new CommitProvider());
        this.treeViewer.setInput(this.commitsfound);
        this.setPageComplete(true);
    }

    class AuthorLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        AuthorLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RevCommit) {
                RevCommit commit = (RevCommit)element;
                return new StyledString(commit.getAuthorIdent().getName());
            }
            return null;
        }
    }

    public class CommitProvider
    implements ITreeContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class DateLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private DateFormat dateLabelFormat = DateFormat.getDateInstance();

        public StyledString getStyledText(Object element) {
            if (element instanceof RevCommit) {
                RevCommit commit = (RevCommit)element;
                return new StyledString(this.dateLabelFormat.format(commit.getCommitterIdent().getWhen()));
            }
            return null;
        }
    }

    class MessageLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        MessageLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RevCommit) {
                RevCommit commit = (RevCommit)element;
                return new StyledString(commit.getFullMessage());
            }
            return null;
        }
    }

    class NameLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        NameLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof RevCommit) {
                RevCommit commit = (RevCommit)element;
                return new StyledString(commit.getName().substring(0, 8));
            }
            return null;
        }
    }
}

