/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.PaGit;
import com.proalpha.pds.gitutils.cherrypick.CherryPick;
import com.proalpha.pds.gitutils.cherrypick.CherryPickCommitPage;
import com.proalpha.pds.gitutils.cherrypick.CherryPickJob;
import com.proalpha.pds.gitutils.cherrypick.CherryPickPage;
import com.proalpha.pds.gitutils.cherrypick.CherryPickSettings;
import com.proalpha.pds.gitutils.cherrypick.GatherCommitsOperation;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CherryPickWizard
extends Wizard {
    private final CherryPickPage cpPage;
    private final CherryPickCommitPage comPage;
    private Repository targetRepository;
    private List<RevCommit> sourceCommits;
    private CherryPickSettings cherryPickSettings = new CherryPickSettings();

    public List<RevCommit> getSourceCommits() {
        return this.sourceCommits;
    }

    public void setSourceRepoString(String sourceRepoString) {
        this.cherryPickSettings.setSourceRepoString(sourceRepoString);
    }

    public void setSourceBranch(String sourceBranch) {
        this.cherryPickSettings.setSourceBranch(sourceBranch);
    }

    public void setSourceIssue(String sourceIssue) {
        this.cherryPickSettings.setSourceIssue(sourceIssue);
    }

    public void setTargetBranch(String targetBranch) {
        this.cherryPickSettings.setTargetBranch(targetBranch);
    }

    public void setTargetIssue(String targetIssue) {
        this.cherryPickSettings.setTargetIssue(targetIssue);
    }

    public CherryPickWizard(Repository repository) {
        this.targetRepository = repository;
        this.cpPage = new CherryPickPage(repository);
        this.comPage = new CherryPickCommitPage();
        this.cherryPickSettings.setTargetRepository(repository.getDirectory().toString());
        PaGit.init((Git)new Git(this.targetRepository));
    }

    public boolean performFinish() {
        try {
            CherryPick.getInstance().createCherryPickCommand(this.cherryPickSettings);
        }
        catch (IOException | GitAPIException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)e.getCause().getMessage(), (String)Arrays.toString(e.getCause().getStackTrace()));
        }
        CherryPickJob cherryPickJob = new CherryPickJob(this.sourceCommits.size());
        cherryPickJob.setUser(true);
        cherryPickJob.setRule(RuleUtil.getRule((Repository)CherryPick.getInstance().getCherryPickCommand().getRepository()));
        cherryPickJob.schedule();
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.cpPage);
        this.addPage((IWizardPage)this.comPage);
    }

    public boolean gatherCommits() {
        GatherCommitsOperation op = new GatherCommitsOperation(this.cherryPickSettings.getSourceRepoString(), this.cherryPickSettings.getSourceBranch(), this.cherryPickSettings.getSourceIssue());
        Runnable r = () -> {
            try {
                op.run();
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)e.getCause().getMessage(), (String)Arrays.toString(e.getCause().getStackTrace()));
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
        this.sourceCommits = op.getOperationResult();
        this.comPage.setCommitsfound(this.sourceCommits);
        return !this.sourceCommits.isEmpty();
    }
}

