/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.PaGitConfig;
import com.proalpha.git.model.server.GitServerRepository;
import com.proalpha.git.util.PaBranchName;
import com.proalpha.git.util.PaRepository;
import com.proalpha.git.util.bitbucket.BitbucketRestCallGetRepoList;
import com.proalpha.git.util.gitblit.GitBlitRpcCallGetRepoList;
import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.cherrypick.CherryPickSettings;
import com.proalpha.pds.gitutils.cherrypick.CherryPickWizard;
import com.proalpha.pds.gitutils.cherrypick.PrefixMatchFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.framework.Bundle;

public class CherryPickPage
extends WizardPage {
    private Repository srcRepository;
    private List<GitServerRepository> currRepos;
    private Button btnUpdateTargetBranchPoint;
    private Combo txtSrcRepository;
    private ComboViewer cvSrcBranch;
    private Text txtSrcFeature;
    private Text txtTargetBranch;
    private Text txtTargetFeature;
    private Button btnFetchCommits;
    private Button btnEditBranchname;
    private CherryPickSettings cherryPickSettings;

    public CherryPickPage(Repository repository) {
        super(CherryPickPage.class.getName());
        this.srcRepository = repository;
        this.setTitle("proALPHA CherryPick");
        this.setMessage("Select repository and branch which needs to get picked into your current repository", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public void createControl(Composite parent) {
        this.cherryPickSettings = ((CherryPickWizard)this.getWizard()).getSettings();
        this.currRepos = this.getServerRepositories();
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createSourceControls(container);
        this.createTargetControls(container);
        this.setControl((Control)container);
        this.btnFetchCommits = new Button(container, 0);
        this.btnFetchCommits.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnFetchCommits.setText("Fetch Commits");
        this.btnFetchCommits.setEnabled(false);
        this.addSrcWidgetListeners();
        this.addTargetWidgetListeners();
        this.addButtonWidgetListeners();
        this.checkRepoAndProposeBranches();
        ITaskActivityManager taskActivityManager = TasksUi.getTaskActivityManager();
        if (taskActivityManager != null && taskActivityManager.getActiveTask() != null && taskActivityManager.getActiveTask().getTaskKey() != null) {
            this.txtSrcFeature.setText(taskActivityManager.getActiveTask().getTaskKey());
            this.txtTargetFeature.setText(taskActivityManager.getActiveTask().getTaskKey());
        }
        this.setPageComplete(false);
    }

    private void createTargetControls(Composite container) {
        Group grpTarget = new Group(container, 0);
        GridData gdGrpTarget = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gdGrpTarget.widthHint = 450;
        gdGrpTarget.heightHint = 110;
        grpTarget.setLayoutData((Object)gdGrpTarget);
        grpTarget.setText("Target");
        Label label1 = new Label((Composite)grpTarget, 0);
        label1.setText("Repository");
        label1.setBounds(10, 22, 80, 15);
        Text txtTargetRepository = new Text((Composite)grpTarget, 0);
        txtTargetRepository.setBounds(96, 23, 347, 21);
        txtTargetRepository.setText(this.srcRepository.getDirectory().toString());
        txtTargetRepository.setEnabled(false);
        Label lblBranchPoint = new Label((Composite)grpTarget, 0);
        lblBranchPoint.setText("Branch Point");
        lblBranchPoint.setBounds(10, 49, 80, 15);
        Text txtTargetBranchPoint = new Text((Composite)grpTarget, 2048);
        txtTargetBranchPoint.setBounds(96, 46, 212, 21);
        txtTargetBranchPoint.setEnabled(false);
        try {
            String remoteTrackingRef;
            List branches = PaRepository.getMasterBranches((Repository)this.srcRepository);
            String mainBranch = null;
            if (branches != null && !branches.isEmpty()) {
                mainBranch = (String)branches.get(0);
            } else {
                branches = PaRepository.getCodeFreezeBranches((Repository)this.srcRepository);
                if (branches != null && !branches.isEmpty()) {
                    mainBranch = (String)branches.get(0);
                }
            }
            if (mainBranch == null) {
                mainBranch = this.srcRepository.getFullBranch();
            }
            if ((remoteTrackingRef = PaRepository.getRemoteTrackingBranch((Repository)this.srcRepository, (String)mainBranch)) == null || remoteTrackingRef.isEmpty()) {
                remoteTrackingRef = "HEAD";
            }
            txtTargetBranchPoint.setText(remoteTrackingRef);
            this.cherryPickSettings.setTargetBranchPoint(remoteTrackingRef);
        }
        catch (IOException ex) {
            this.setMessage("Could not determine the branch name to be used as branching point!", 3);
        }
        this.btnUpdateTargetBranchPoint = new Button((Composite)grpTarget, 32);
        this.btnUpdateTargetBranchPoint.setBounds(314, 48, 129, 16);
        this.btnUpdateTargetBranchPoint.setText("update/fetch");
        this.btnUpdateTargetBranchPoint.setSelection(this.cherryPickSettings.isUpdateTargetBranchPoint());
        Label label2 = new Label((Composite)grpTarget, 0);
        label2.setText("Branch");
        label2.setBounds(10, 76, 80, 15);
        this.txtTargetBranch = new Text((Composite)grpTarget, 2048);
        this.txtTargetBranch.setBounds(96, 73, 212, 21);
        this.txtTargetBranch.setEnabled(false);
        this.btnEditBranchname = new Button((Composite)grpTarget, 32);
        this.btnEditBranchname.setBounds(314, 75, 129, 16);
        this.btnEditBranchname.setText("modify branch name");
        Label label3 = new Label((Composite)grpTarget, 0);
        label3.setText("Feature");
        label3.setBounds(10, 103, 80, 15);
        this.txtTargetFeature = new Text((Composite)grpTarget, 2048);
        this.txtTargetFeature.setBounds(96, 101, 162, 21);
    }

    private void createSourceControls(Composite container) {
        String gitDefaultRepo = Activator.getDefault().getPreferenceStore().getString("PaGitDefaultRepo");
        Group grpSource = new Group(container, 0);
        GridData gdGrpSource = new GridData(0x1000000, 128, true, false, 1, 1);
        gdGrpSource.heightHint = 85;
        gdGrpSource.widthHint = 450;
        grpSource.setLayoutData((Object)gdGrpSource);
        grpSource.setText("Source");
        Label lblRepository = new Label((Composite)grpSource, 0);
        lblRepository.setText("Repository");
        lblRepository.setBounds(10, 22, 80, 15);
        Label lblBranch = new Label((Composite)grpSource, 0);
        lblBranch.setText("Branch");
        lblBranch.setBounds(10, 49, 80, 15);
        Label lblFeature = new Label((Composite)grpSource, 0);
        lblFeature.setText("Feature");
        lblFeature.setBounds(10, 76, 80, 15);
        this.txtSrcRepository = new Combo((Composite)grpSource, 2048);
        this.txtSrcRepository.setBounds(96, 19, 212, 21);
        Object[] repos = new String[this.currRepos.size()];
        int i = 0;
        while (i < this.currRepos.size()) {
            repos[i] = this.currRepos.get(i).getDisplayName();
            ++i;
        }
        Arrays.sort(repos);
        this.txtSrcRepository.setItems((String[])repos);
        this.txtSrcRepository.select(Arrays.binarySearch(repos, gitDefaultRepo));
        PrefixMatchFilter branchFilter = new PrefixMatchFilter();
        this.cvSrcBranch = new ComboViewer((Composite)grpSource, 2048);
        this.cvSrcBranch.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvSrcBranch.getCombo().setBounds(96, 46, 212, 21);
        this.cvSrcBranch.addFilter((ViewerFilter)branchFilter);
        this.txtSrcFeature = new Text((Composite)grpSource, 2048);
        this.txtSrcFeature.setBounds(96, 73, 162, 21);
        Button btnRefreshRepos = new Button((Composite)grpSource, 0);
        btnRefreshRepos.setToolTipText("Reload repositories from server");
        btnRefreshRepos.setImage(ResourceManager.getPluginImage("com.proalpha.pds.gitutils", "icons/refresh.gif"));
        btnRefreshRepos.setBounds(314, 18, 28, 23);
    }

    private void addSrcWidgetListeners() {
        this.txtSrcRepository.addModifyListener(modifyEvent -> this.checkRepoAndProposeBranches());
        this.txtSrcRepository.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose your source repository");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.cvSrcBranch.getCombo().getText().length() != 0) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        this.cvSrcBranch.getCombo().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose your source branch");
            }

            public void focusLost(FocusEvent e) {
                String featureByBranch;
                if (CherryPickPage.this.cvSrcBranch.getCombo().getText().length() != 0 && CherryPickPage.this.checkBranch() && (featureByBranch = CherryPickPage.this.getFeatureText(CherryPickPage.this.cvSrcBranch.getCombo().getText())) != null) {
                    CherryPickPage.this.txtSrcFeature.setText(featureByBranch);
                }
            }
        });
        this.txtSrcFeature.addModifyListener(modifyEvent -> {
            if (this.cvSrcBranch.getCombo().getText().length() != 0) {
                this.checkBranch();
                this.txtTargetFeature.setText(this.txtSrcFeature.getText());
            }
        });
        this.txtSrcFeature.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Type your feature to pick");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.cvSrcBranch.getCombo().getText().length() != 0 && CherryPickPage.this.txtSrcFeature.getText().length() != 0) {
                    CherryPickPage.this.btnFetchCommits.setEnabled(true);
                }
            }
        });
        this.cvSrcBranch.getCombo().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String currentInput = CherryPickPage.this.cvSrcBranch.getCombo().getText();
                String inputFilter = ((PrefixMatchFilter)CherryPickPage.this.cvSrcBranch.getFilters()[0]).getInput();
                if (currentInput.length() < inputFilter.length() || Character.isDigit(e.character) || Character.isAlphabetic(e.character)) {
                    if (e.keyCode == 27) {
                        ((PrefixMatchFilter)CherryPickPage.this.cvSrcBranch.getFilters()[0]).setInput("");
                        currentInput = "";
                    } else {
                        ((PrefixMatchFilter)CherryPickPage.this.cvSrcBranch.getFilters()[0]).setInput(currentInput);
                    }
                    CherryPickPage.this.cvSrcBranch.refresh(true);
                    CherryPickPage.this.cvSrcBranch.getCombo().setListVisible(e.keyCode != 27);
                    CherryPickPage.this.cvSrcBranch.getCombo().setText(currentInput);
                    CherryPickPage.this.cvSrcBranch.getCombo().setSelection(new Point(currentInput.length(), currentInput.length()));
                }
            }
        });
        this.cvSrcBranch.getCombo().addModifyListener(modifyListener -> {
            String featureByBranch;
            if (this.cvSrcBranch.getCombo().getText().length() != 0 && this.checkBranch() && (featureByBranch = this.getFeatureText(this.cvSrcBranch.getCombo().getText())) != null) {
                this.txtSrcFeature.setText(featureByBranch);
            }
        });
    }

    private void addTargetWidgetListeners() {
        this.txtTargetBranch.addModifyListener(modifyEvent -> {
            if (this.txtTargetBranch.getText().length() != 0) {
                this.cherryPickSettings.setTargetBranch(this.txtTargetBranch.getText());
            }
        });
        this.txtTargetBranch.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Type your new branchname");
            }

            public void focusLost(FocusEvent e) {
                String featureByBranch;
                if (CherryPickPage.this.txtTargetBranch.getText().length() != 0 && (featureByBranch = CherryPickPage.this.getFeatureText(CherryPickPage.this.txtTargetBranch.getText())) != null) {
                    CherryPickPage.this.txtTargetFeature.setText(featureByBranch);
                }
            }
        });
        this.txtTargetFeature.addModifyListener(modifyEvent -> {
            if (this.txtTargetFeature.getText().length() != 0) {
                this.cherryPickSettings.setTargetIssue(this.txtTargetFeature.getText());
            }
        });
        this.txtTargetFeature.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose a target feature which is used for first line of commit message");
            }

            public void focusLost(FocusEvent e) {
                String featureByBranch;
                if (CherryPickPage.this.txtTargetFeature.getText().length() == 0 && (featureByBranch = CherryPickPage.this.getFeatureText(CherryPickPage.this.txtTargetBranch.getText())) != null) {
                    CherryPickPage.this.txtTargetFeature.setText(featureByBranch);
                }
                CherryPickPage.this.cherryPickSettings.setTargetIssue(CherryPickPage.this.txtTargetFeature.getText());
            }
        });
        this.btnUpdateTargetBranchPoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.cherryPickSettings.setUpdateTargetBranchPoint(CherryPickPage.this.btnUpdateTargetBranchPoint.getSelection());
            }
        });
    }

    private void addButtonWidgetListeners() {
        this.btnEditBranchname.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.txtTargetBranch.setEnabled(CherryPickPage.this.btnEditBranchname.getSelection());
                if (!CherryPickPage.this.btnEditBranchname.getSelection()) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        this.btnFetchCommits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.fetchCommits();
            }
        });
    }

    protected void fetchCommits() {
        this.cherryPickSettings.setSourceIssue(this.txtSrcFeature.getText());
        this.cherryPickSettings.setSourceBranch(this.cvSrcBranch.getCombo().getText());
        this.cherryPickSettings.setTargetIssue(this.txtTargetFeature.getText());
        for (GitServerRepository actRepo : this.currRepos) {
            if (!actRepo.getDisplayName().equals(this.txtSrcRepository.getText())) continue;
            this.cherryPickSettings.setSourceRepoString(actRepo.getDisplayName());
            break;
        }
        Boolean commitsfound = ((CherryPickWizard)this.getWizard()).gatherCommits();
        if (!commitsfound.booleanValue()) {
            this.setMessage("No commits found!", 2);
        } else {
            this.setMessage("Commits found! Push 'Next' to view or 'Finish' to pick them", 1);
        }
        this.setPageComplete(commitsfound);
    }

    private List<GitServerRepository> getServerRepositories() {
        ArrayList serverRepositories;
        String gitServerPath = Activator.getDefault().getPreferenceStore().getString("PaGitServerUrl");
        if (gitServerPath.contains("/gitblit")) {
            GitBlitRpcCallGetRepoList rpc = new GitBlitRpcCallGetRepoList(Activator.getDefault().getPreferenceStore().getString("PaGitServerUrl"));
            rpc.execute();
            serverRepositories = (ArrayList)rpc.getRpcResponse();
        } else {
            BitbucketRestCallGetRepoList restcall = new BitbucketRestCallGetRepoList();
            restcall.setSubUrl("repos");
            restcall.execute();
            serverRepositories = (ArrayList)restcall.getRestResponse();
        }
        return serverRepositories;
    }

    private String getFeatureText(String branchText) {
        Pattern p = Pattern.compile("(.*\\.)?(" + PaGitConfig.getStringFromConfig((String)"issue_key_format") + ")$");
        Matcher m = p.matcher(branchText);
        if (m.find()) {
            return m.group(2);
        }
        return null;
    }

    private boolean checkBranch() {
        boolean foundIt = false;
        String srcBranchName = this.cvSrcBranch.getCombo().getText();
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (srcBranchName.length() == 0) {
            this.setPageComplete(false);
            return false;
        }
        for (GitServerRepository actRepo : this.currRepos) {
            if (actRepo.getDisplayName().equals(this.txtSrcRepository.getText())) {
                for (String actBranch : actRepo.getBranches()) {
                    if (!actBranch.equals(srcBranchName)) continue;
                    foundIt = true;
                }
            }
            if (foundIt) break;
        }
        if (!foundIt) {
            this.setMessage("Branch not found!", 2);
            this.setPageComplete(false);
            this.btnFetchCommits.setEnabled(false);
            return false;
        }
        this.cherryPickSettings.setSourceBranch(srcBranchName);
        this.proposeTargetBranchName(srcBranchName);
        this.btnFetchCommits.setEnabled(true);
        return true;
    }

    private void proposeTargetBranchName(String srcBranchName) {
        String targetBranch = srcBranchName;
        try {
            targetBranch = this.txtSrcFeature.getText() != null && !this.txtSrcFeature.getText().isEmpty() ? String.valueOf(PaBranchName.getVersion((String)this.srcRepository.getBranch())) + "." + this.txtSrcFeature.getText() : String.valueOf(PaBranchName.getVersion((String)this.srcRepository.getBranch())) + ".";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.txtTargetBranch.setText(targetBranch);
        this.cherryPickSettings.setTargetBranch(targetBranch);
    }

    protected void checkRepoAndProposeBranches() {
        boolean foundIt = false;
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (this.txtSrcRepository.getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        for (GitServerRepository actRepo : this.currRepos) {
            if (!actRepo.getDisplayName().equals(this.txtSrcRepository.getText())) continue;
            List allBranches = actRepo.getBranches();
            Collections.sort(allBranches);
            String[] branches = (String[])allBranches.stream().toArray(String[]::new);
            this.cvSrcBranch.setInput((Object)branches);
            foundIt = true;
            break;
        }
        if (!foundIt) {
            this.setMessage("Repository not found!", 2);
            this.setPageComplete(false);
            this.btnFetchCommits.setEnabled(false);
            this.cvSrcBranch.setInput((Object)new String[0]);
            return;
        }
        this.cherryPickSettings.setSourceRepoString(this.txtSrcRepository.getText());
    }
}

