/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util.bitbucket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.proalpha.pds.pagit.model.server.BitbucketCloudBranch;
import com.proalpha.pds.pagit.model.server.BitbucketCloudRestBranchListResponse;
import com.proalpha.pds.pagit.util.bitbucket.BitbucketRestCall;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCloudRestCallGetBranchList
extends BitbucketRestCall<ArrayList<String>> {
    private final Logger logger = LoggerFactory.getLogger(BitbucketCloudRestCallGetBranchList.class);

    @Override
    protected ArrayList<String> parseRestResponse(InputStream response) throws IOException {
        ArrayList<String> branchList = new ArrayList<String>();
        try {
            BitbucketCloudRestBranchListResponse resp = (BitbucketCloudRestBranchListResponse)new ObjectMapper().readValue(response, BitbucketCloudRestBranchListResponse.class);
            for (BitbucketCloudBranch branch : resp.getValues()) {
                this.logger.debug("Add Branch: {}", (Object)branch.getName());
                branchList.add(branch.getName());
            }
            if (resp.getNext() != null && !resp.getNext().trim().isEmpty()) {
                this.setStartEntry(resp.getPage() + 1);
                this.execute();
                branchList.addAll((Collection)this.getRestResponse());
            }
        }
        catch (NullPointerException e) {
            this.logger.debug("NPE occured, due to empty http-response {}", (Object)e.getMessage());
        }
        return branchList;
    }
}

