/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.core.runtime.IPropath;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProjectPlugin;
import com.proalpha.pds.paconnector.RunProgramInPa;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;

public class PaConnectorPropertyTester
extends PropertyTester {
    static final String USEREXITFILEEXTENTIONS = "w,p,lib";
    static final String USEREXITCUSTOMLEVELS = "c,q,u,x,y,z";
    List<String> userexitfiletypes = new ArrayList<String>();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        StructuredSelection selection;
        IProject project = null;
        Object firstObject = null;
        TreeSelection treeSelect = null;
        IResource currResource = null;
        if (receiver instanceof IStructuredSelection && (firstObject = (selection = new StructuredSelection(receiver)).getFirstElement()) instanceof TreeSelection) {
            treeSelect = (TreeSelection)firstObject;
        }
        if (receiver instanceof TreeSelection || treeSelect != null) {
            firstObject = treeSelect.getFirstElement();
            if (firstObject instanceof IProject) {
                project = (IProject)firstObject;
            }
            if (firstObject instanceof IFile) {
                currResource = (IResource)firstObject;
                project = currResource.getProject();
            }
        }
        if (project == null) {
            return false;
        }
        IOpenEdgeProject currProj = OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject(project);
        if (currProj == null) {
            return false;
        }
        IAVMClient runtime = currProj.getRuntime();
        if (runtime == null) {
            return false;
        }
        if (!runtime.isConnected()) {
            return false;
        }
        if ("isConnected".equalsIgnoreCase(property)) {
            return runtime.isConnected();
        }
        if ("ispAConnected".equalsIgnoreCase(property)) {
            IPropath propath = currProj.getPropath();
            return propath.search("paoidebr.p", true) != null;
        }
        if ("isAramis".equalsIgnoreCase(property)) {
            try {
                RunProgramInPa pabridge = new RunProgramInPa(currProj);
                return pabridge.getpAStartupParam("VMVersionControlSystem", "").equals("2");
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ("canCreateUserExit".equalsIgnoreCase(property)) {
            if (currResource != null && this.userexitpossible(currResource.getFileExtension())) {
                IPath uefilename;
                String customlevel = null;
                RunProgramInPa pabridge = new RunProgramInPa(currProj);
                customlevel = pabridge.getpAStartupParam("CustomLevel", "");
                if (customlevel != null && !customlevel.isEmpty() && !(uefilename = this.getUserExitFileName(currResource.getRawLocation(), customlevel)).toFile().exists()) {
                    System.out.println("canCreateUserExit=yes");
                    return true;
                }
            }
            System.out.println("canCreateUserExit=false");
            return false;
        }
        if ("UEpossible".equalsIgnoreCase(property)) {
            if (currResource != null) {
                System.out.println("UEpossible=" + this.userexitpossible(currResource.getFileExtension()));
                return this.userexitpossible(currResource.getFileExtension());
            }
            return false;
        }
        if ("isUEFileType".equalsIgnoreCase(property)) {
            if (currResource != null) {
                if (this.userexitfiletypes.isEmpty()) {
                    this.generateUserExitFileTypes();
                }
                if (this.userexitfiletypes.contains(currResource.getFileExtension())) {
                    System.out.println("isUEFileType=yes");
                    return true;
                }
            }
            System.out.println("isUEFileType=false");
            return false;
        }
        return false;
    }

    private IPath getUserExitFileName(IPath procedurename, String customlevel) {
        String newExtention = String.valueOf(customlevel.substring(0, 1)) + "x" + procedurename.getFileExtension().substring(0, 1);
        procedurename = procedurename.removeFileExtension();
        procedurename = procedurename.addFileExtension(newExtention);
        return procedurename;
    }

    private void generateUserExitFileTypes() {
        String[] filetypes = USEREXITFILEEXTENTIONS.split(",");
        String[] customlevels = USEREXITCUSTOMLEVELS.split(",");
        String nexFileExt = "";
        String[] stringArray = customlevels;
        int n = customlevels.length;
        int n2 = 0;
        while (n2 < n) {
            String level = stringArray[n2];
            String[] stringArray2 = filetypes;
            int n3 = filetypes.length;
            int n4 = 0;
            while (n4 < n3) {
                String type = stringArray2[n4];
                nexFileExt = String.valueOf(level) + "x" + type.substring(0, 1);
                this.userexitfiletypes.add(nexFileExt);
                ++n4;
            }
            ++n2;
        }
    }

    private boolean userexitpossible(String fileextention) {
        String[] results;
        String[] stringArray = results = USEREXITFILEEXTENTIONS.split(",");
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            String result = stringArray[n2];
            if (result.equalsIgnoreCase(fileextention)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

