/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector;

import com.openedge.pdt.project.OEProject;
import com.openedge.pdt.project.OEProjectPlugin;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaPreference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectHandler {
    private static final String PLUGIN_ID = Activator.getDefault().getBundle().getSymbolicName();
    IProject project = null;

    public ProjectHandler() {
        ISelection sel;
        ISelectionService ss = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        String projExpID = "org.eclipse.ui.navigator.ProjectExplorer";
        Object selectedObject = sel = ss.getSelection(projExpID);
        if (sel instanceof IStructuredSelection) {
            selectedObject = ((IStructuredSelection)sel).getFirstElement();
        }
        if (selectedObject instanceof IAdaptable) {
            IResource res = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class);
            this.project = res.getProject();
        }
    }

    public ProjectHandler(IProject project) {
        this.project = project;
    }

    public IProject getActiveProject() {
        return this.project;
    }

    public OEProject getActiveOEProject() {
        if (this.getActiveProject() != null) {
            return (OEProject)OEProjectPlugin.getDefault().getOpenEdgeModel().getOpenEdgeProject(this.project);
        }
        return null;
    }

    public boolean iscurrentProjectOpen() {
        return this.project.isOpen();
    }

    public String getActiveProjectName() {
        return this.project.toString();
    }

    public List<PaPreference> loadPaPrefs() {
        ProjectScope ctxt = new ProjectScope(this.getActiveProject());
        IEclipsePreferences prefs = ctxt.getNode(PLUGIN_ID);
        ArrayList<PaPreference> paPrefs = new ArrayList<PaPreference>();
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pakey = stringArray[n2];
                PaPreference tmpPref = new PaPreference(pakey, prefs.get(pakey, ""));
                paPrefs.add(tmpPref);
                ++n2;
            }
            return paPrefs;
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return new ArrayList<PaPreference>();
        }
    }

    public boolean savePaPref(String name, String value) {
        ProjectScope ctxt = new ProjectScope(this.getActiveProject());
        IEclipsePreferences prefs = ctxt.getNode(PLUGIN_ID);
        if (name == null || value == null || prefs == null) {
            return false;
        }
        prefs.put(name, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            return false;
        }
        return true;
    }
}

