/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.configure;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class PdsLaunchConfigurator {
    private String projectVersion;
    private String progressVersion;
    private String startupProgram;
    private String workingDirectory;
    private String clientLogDirectory;
    private String startupParameters;
    private static final String STREAM_CODE_PAGE = "ISO8859-1";
    private static final String INTERNAL_CODE_PAGE = "ISO8859-1";
    private static final String NUM_SEP = "46";
    private static final String NUM_DEC = "44";
    private static final String DATE_FORMAT = "dmy";
    private static final String COLLATION_TABLE = "German-Library";
    private static final String CASE_TABLE = "Basic";

    public PdsLaunchConfigurator(String project, String version, String startupProgram, String workingDirectory, String clientLogDirectory, String startupParameters) {
        this.projectVersion = project;
        this.progressVersion = version;
        this.startupProgram = startupProgram;
        this.workingDirectory = workingDirectory;
        this.clientLogDirectory = clientLogDirectory;
        this.startupParameters = startupParameters;
    }

    public void createNewLaunchConfiguration() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("abl.launchType");
        try {
            ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, this.projectVersion);
            configuration.setAttribute("abl.debug.ATTR_ABL_PROJECT_NAME", this.projectVersion);
            configuration.setAttribute("abl.debug.ABL_PROGRAM", this.startupProgram);
            configuration.setAttribute("abl.startup.WORKING_DIRECTORY", this.workingDirectory);
            configuration.setAttribute("abl.client.PROVERSION", this.progressVersion);
            configuration.setAttribute("abl.debug.PROPATH_USE_DEFAULT", true);
            configuration.setAttribute("abl.debug.PROPATH", null);
            configuration.setAttribute("abl.databases.USE_PROJECT", true);
            configuration.setAttribute("abl.databases.ABL_DATABASES", null);
            configuration.setAttribute("abl.logging.APPEND_LOG", true);
            configuration.setAttribute("abl.logging.CLIENT_LOG", this.clientLogDirectory);
            configuration.setAttribute("abl.i18n.CASE_TABLE", CASE_TABLE);
            configuration.setAttribute("abl.i18n.COLLATION_TABLE", COLLATION_TABLE);
            configuration.setAttribute("abl.i18n.DATE_FORMAT", DATE_FORMAT);
            configuration.setAttribute("abl.i18n.FRACTIONAL_SEP", NUM_DEC);
            configuration.setAttribute("abl.i18n.THOUSANDS_SEP", NUM_SEP);
            configuration.setAttribute("abl.i18n.INTERNAL_CODE_PAGE", "ISO8859-1");
            configuration.setAttribute("abl.i18n.STREAM_CODE_PAGE", "ISO8859-1");
            configuration.setAttribute("abl.startup.STARTUP_PARAMETERS", this.startupParameters.replace(",INWBConnect=no", ""));
            configuration.setAttribute("org.eclipse.debug.core.MAPPED_RESOURCE_PATHS", Arrays.asList("/" + this.projectVersion));
            configuration.setAttribute("org.eclipse.debug.core.MAPPED_RESOURCE_TYPES", Arrays.asList("4"));
            configuration.setAttribute("org.eclipse.debug.core.capture_output", false);
            configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            configuration.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

