/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.importWizards;

import com.proalpha.pds.projconf.importWizards.ImportPageOne;
import com.proalpha.pds.projconf.importWizards.ImportProjectJob;
import com.proalpha.pds.projconf.importWizards.ReadDemasFile;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportWizard
extends Wizard
implements IImportWizard {
    protected ImportPageOne one;

    public ImportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        return "Import DEMAS Installation";
    }

    public void addPages() {
        this.one = new ImportPageOne();
        this.addPage((IWizardPage)this.one);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Import proALPHA Project");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        List<String> importProjects = this.one.getProjectFiles();
        System.out.println(importProjects.toString());
        for (String project : importProjects) {
            this.createProjectFromIniFile(project);
        }
        return true;
    }

    private void createProjectFromIniFile(String demasfile) {
        ReadDemasFile installed = new ReadDemasFile(demasfile);
        if (!installed.isValidIni()) {
            return;
        }
        ImportProjectJob importProjectJob = new ImportProjectJob(MessageFormat.format("Importing Project {0}", installed.getProject()), installed);
        importProjectJob.setUser(true);
        importProjectJob.schedule();
    }
}

