/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.configure;

import com.openedge.pdt.platform.PlatformPlugin;
import com.openedge.pdt.platform.PlatformSupport;
import com.openedge.pdt.platform.Proversion;
import com.openedge.pdt.project.OEPropertyStore;
import com.openedge.pdt.project.ProjectPropath;
import com.openedge.pdt.project.PropathEntry;
import com.openedge.pdt.project.PropathEnvironmentEntry;
import com.openedge.pdt.project.facet.openedge.OECommonDataModelProvider;
import com.openedge.pdt.project.facet.openedge.ProjectPropathWizardPage;
import com.openedge.pdt.project.projecttypespecification.IOEProjectTypeSpecification;
import com.openedge.pdt.project.projecttypespecification.OEProjectTypesSpecificationManager;
import com.proalpha.pds.projconf.configure.DatabaseConnectionBuilder;
import com.proalpha.pds.projconf.configure.PdsLaunchConfigurator;
import com.proalpha.pds.projconf.utils.ProgressUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurePdsProject {
    private final Logger logger = LoggerFactory.getLogger(ConfigurePdsProject.class);
    private String project;
    private String version;
    private String environment;
    private String startParameter;
    private String linkedFolderList;
    private String appserversList;
    private String dbProperties;
    private String proPath;
    private String projectDir;
    private String dbDir;
    private String assembliesDir;
    private String dlcDir;
    private String objDir;
    private String tempDir;
    private String projectIdentifier;
    private PlatformSupport supportPlatform;
    private String repositoryUrl;
    private String jiraUrl;
    private String jiraProject;

    public ConfigurePdsProject(String project, String version, String environment, String startParameter, String linkedFolderList, String appserversList, String dbProperties, String proPath, String projectDir, String dbDir, String assembliesDir, String dlcDir, String objDir, String tempDir, String repositoryUrl, String jiraUrl, String jiraProject) {
        this.project = project;
        this.version = version;
        this.environment = environment;
        this.startParameter = startParameter;
        this.linkedFolderList = linkedFolderList;
        this.appserversList = appserversList;
        this.dbProperties = dbProperties;
        this.proPath = proPath;
        this.projectDir = projectDir;
        this.dbDir = dbDir;
        this.assembliesDir = assembliesDir;
        this.dlcDir = dlcDir;
        this.objDir = objDir;
        this.tempDir = tempDir;
        this.repositoryUrl = repositoryUrl;
        this.jiraUrl = jiraUrl;
        this.jiraProject = jiraProject;
        this.projectIdentifier = String.valueOf(project) + "-" + version + "-" + environment;
        this.supportPlatform = PlatformPlugin.getDefault().getPlatformSupport();
    }

    public IProject createProject() throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask("Create new OpenEdge Project", -1);
        IProjectFacet openedgeFacet = ProjectFacetsManager.getProjectFacet((String)"openedge.project");
        HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
        fixedFacets.add(openedgeFacet);
        IFacetedProject fproj = ProjectFacetsManager.create((String)this.projectIdentifier, (IPath)new Path(this.projectDir), (IProgressMonitor)monitor);
        IActionDefinition actionDefinition = openedgeFacet.getVersion("11").getActionDefinition(Collections.singleton(openedgeFacet.getVersion("11")), IFacetedProject.Action.Type.INSTALL);
        IDataModel openEdgeDataModel = (IDataModel)actionDefinition.createConfigObject();
        openEdgeDataModel.setProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY", (Object)fproj.createWorkingCopy());
        openEdgeDataModel.setStringProperty("IFacetDataModelProperties.FACET_ID", "openedge.project");
        IOEProjectTypeSpecification oeProjectTypeSpecification = OEProjectTypesSpecificationManager.getProjectTypesSpecificationManager().getProjectTypeSpecification(openedgeFacet);
        openEdgeDataModel.setProperty("IOEProjectDataModelProperties.CP_SPECIFIACTION", (Object)oeProjectTypeSpecification);
        openEdgeDataModel.setStringProperty("IOEProjectDataModelProperties.BUILD_DIRECTORY_PATH", this.objDir);
        openEdgeDataModel.setBooleanProperty("IOEProjectDataModelProperties.USE_PROJECT_ROOT", false);
        IDataModel commonDataModel = DataModelFactory.createDataModel((IDataModelProvider)new OECommonDataModelProvider());
        commonDataModel.setStringProperty("IOECommonDataModelProperties.PROJECT_LOCATION", this.projectDir);
        ProgressUtils utils = new ProgressUtils(this.supportPlatform);
        Proversion proversion = utils.getProgressVersion();
        commonDataModel.setProperty("IOEProjectDataModelProperties.PROVERSION", (Object)proversion);
        openEdgeDataModel.addNestedModel("IOEProjectDataModelProperties.COMMON_MODEL", commonDataModel);
        openEdgeDataModel.setProperty("IOEProjectDataModelProperties.COMMON_MODEL", (Object)commonDataModel);
        OEPropertyStore oePropertyStore = new OEPropertyStore(fproj.getProject());
        oePropertyStore.setProperty("pvm_workdir", this.projectDir);
        oePropertyStore.setProperty("pvm_tempdir", this.tempDir);
        oePropertyStore.setProperty("pvm_startup", this.startParameter);
        oePropertyStore.setProperty("pvm_use_workspace_avm", "true");
        if (this.assembliesDir != null && new File(this.assembliesDir).exists()) {
            oePropertyStore.setProperty("pvm_use_default_assemblies_directory", "false");
            oePropertyStore.setProperty("pvm_assemblies_directory", this.assembliesDir);
        }
        oePropertyStore.setProperty("bld_rcodepath", this.objDir);
        ProjectPropathWizardPage wizardPage = (ProjectPropathWizardPage)commonDataModel.getProperty("IOECommonDataModelProperties.PROPATH_PAGE");
        if (wizardPage != null) {
            wizardPage.setUserModifiedPropaths(true);
        }
        List<PropathEntry> propahtList = this.loadPropath(Platform.getLocation().append(fproj.getProject().getName()));
        commonDataModel.setProperty("IOECommonDataModelProperties.PROPATH_ENTRIES", propahtList);
        commonDataModel.setBooleanProperty("IOECommonDataModelProperties.UPDATE_PROPATH", true);
        fproj.installProjectFacet(openedgeFacet.getVersion("11"), (Object)openEdgeDataModel, null);
        IFacetedProjectWorkingCopy fprowk = fproj.createWorkingCopy();
        fprowk.setSelectedPreset("openedge.project.preset");
        return fproj.getProject();
    }

    public void installPaProject() throws CoreException, IOException {
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        for (IProject p : projects) {
            if (!p.getName().equals(this.projectIdentifier)) continue;
            return;
        }
        this.cleanupProjectFiles();
        IProject oeProject = this.createProject();
        this.configurePaProject(oeProject);
        String username = System.getProperty("user.name");
        this.configureMylyn(this.jiraUrl, "proAlpha", this.jiraProject, username, "All issues assigned to me");
    }

    public void configureMylyn(String jiraRepositoryUrl, String category, String repositoryLabel, String userName, String repositorySummary) {
        TaskRepository repository = new TaskRepository("jira", jiraRepositoryUrl);
        repository.setCategory(category);
        repository.setRepositoryLabel(repositoryLabel);
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        if (TasksUi.getRepositoryManager().getRepository("jira", jiraRepositoryUrl) == null) {
            this.logger.debug("Repository " + repository.getRepositoryUrl() + " hinzugef\u00fcgt");
            TasksUi.getRepositoryManager().addRepository(repository);
        }
        RepositoryQuery repQuery = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(repository);
        repQuery.setSummary(repositorySummary);
        repQuery.setUrl(this.jiraUrl);
        repQuery.setAttribute("FilterJql", "issuetype in (standardIssueTypes(), subTaskIssueTypes()) AND resolution in (Unresolved, Duplicate, \"Decision needed\", \"Cannot Reproduce\") AND assignee in (currentUser()) ORDER BY assignee ASC, priority DESC, updated DESC");
        repQuery.setAttribute("FilterID", "10605");
        Set repositoryQueries = TasksUiPlugin.getTaskList().getRepositoryQueries(repository.getRepositoryUrl());
        Predicate<RepositoryQuery> repositoryUrl = p -> p.getRepositoryUrl() == repository.getRepositoryUrl();
        Predicate<RepositoryQuery> summeryPredicate = p -> p.getSummary().equals(repositorySummary);
        if (repositoryQueries.stream().filter(summeryPredicate.and(repositoryUrl)).findAny().orElse(null) == null) {
            this.logger.debug("Query: " + repQuery.getAttribute("FilterJql"));
            TasksUiPlugin.getTaskList().addQuery(repQuery);
        }
    }

    private void configurePaProject(IProject oeProject) throws IOException {
        DatabaseConnectionBuilder databaseConnectionBuilder = new DatabaseConnectionBuilder(this.projectIdentifier, this.dbProperties, false, this.dbDir, this.dlcDir);
        databaseConnectionBuilder.createDbConnections(oeProject);
        this.addLinkedFolder(oeProject);
        ProgressUtils utils = new ProgressUtils(this.supportPlatform);
        new PdsLaunchConfigurator(this.projectIdentifier, utils.getOpenEdgeVersionWithMinor(), "pastartg.p", this.projectDir, this.projectDir, this.startParameter).createNewLaunchConfiguration();
    }

    private List<PropathEntry> loadPropath(IPath projectPath) {
        ArrayList<PropathEntry> propathList = new ArrayList<PropathEntry>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(new File(this.proPath)));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    propathList.add(this.getPropathEntry("src", "all", line));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ProjectPropath propathHandler = new ProjectPropath(projectPath);
        PropathEntry[] propathEntryArray = propathHandler.getPropathEntries();
        int n = propathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropathEntry entry = propathEntryArray[n2];
            if (entry.getPath().equals("@{WORK}")) {
                PropathEntry newEntry = this.getPropathEntry("src", "all", entry.getPath());
                propathList.add(newEntry);
            } else {
                propathList.add(entry);
            }
            ++n2;
        }
        return propathList;
    }

    private PropathEntry getPropathEntry(String kind, String env, String path) {
        PropathEntry propathEntry = new PropathEntry(kind);
        propathEntry.setEnvironment(new PropathEnvironmentEntry(env));
        propathEntry.setPath(path);
        return propathEntry;
    }

    private void addLinkedFolder(IProject project) {
        List<Object> folderList = new ArrayList();
        if (this.linkedFolderList != null && !this.linkedFolderList.isEmpty()) {
            folderList = Arrays.asList(this.linkedFolderList.split(","));
        }
        if (!folderList.isEmpty()) {
            for (String folder : folderList) {
                this.createLinkedFolder(project, new Path(folder).lastSegment(), (IPath)new Path(folder));
            }
        }
    }

    private void createLinkedFolder(IProject project, String newFolder, IPath linkedFolder) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFolder link = project.getFolder(newFolder);
            if (workspace.validateLinkLocation((IResource)link, linkedFolder).matches(4)) {
                throw new Exception(workspace.validateLinkLocation((IResource)link, linkedFolder).getException());
            }
            link.createLink(linkedFolder, 0, null);
        }
        catch (Exception e) {
            this.logger.error("Could not create linked folder", (Throwable)e);
        }
    }

    private void cleanupProjectFiles() {
        String[] stringArray = ".project,.propath,.dbconnection,.settings".split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            File misc = new File(new Path(this.projectDir).append(str).toString());
            if (misc.exists()) {
                FileUtils.deleteQuietly((File)misc);
            }
            ++n2;
        }
    }
}

