/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf;

import com.proalpha.pds.projconf.configure.ConfigurePdsProject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigurePdsProjectTest {
    private String startParameter;
    private String linkedFolderList;
    private String appserversList;
    private String dbProperties;
    private String proPath;
    private String projectDir;
    private String dbDir;
    private String assembliesDir;
    private String dlcDir;
    private String objDir;
    private String tempDir;
    private String repositorUrl;
    private String jiraUrl;
    private String jiraProject;
    private String consistencyChecksLocation;
    private ConfigurePdsProject testProject;
    private String project;
    private String enviroment;
    private String version;

    @Before
    public void setUp() {
        this.startParameter = "-pf D:\\proalpha\\proalpha\\proalpha-de-71c01\\production\\startup\\client\\pastartui.pf -pf D:\\proalpha\\proalpha\\proalpha-de-71c01\\production\\startup\\client\\pastartui-pool-a.pf -ininame \"SOFTWARE\\proALPHA\\proalpha-de-71c01\\client-production\" -param \"ConfigFile=D:\\proalpha\\proalpha\\proalpha-de-71c01\\common\\startup\\client\\pastart.xml,SessionType=production-Developer-nA,UserID=System,Password=compakt\"";
        this.linkedFolderList = "D:\\proalpha\\proalpha-code\\proalpha-de-71c01\\production\\dev,D\\:\\proalpha\\proalpha-code\\proalpha-de-71c01\\production\\dev\\..\\dev_config";
        this.appserversList = "proalpha-de-71c01-production-a-cal,proalpha-de-71c01-production-a-cal-lic,proalpha-de-71c01-production-a-dms,proalpha-de-71c01-production-a-sas,proalpha-de-71c01-production-a-sfi,proalpha-de-71c01-production-sfe,proalpha-de-71c01-production-sfin";
        this.dbProperties = "D:\\ProjekteIntern\\FilesfuerOEProjektanlage\\dbconnection.properties";
        this.proPath = "D:\\ProjekteIntern\\FilesfuerOEProjektanlage\\propath.txt";
        this.projectDir = "D:\\proalpha\\proalpha\\proalpha-de-71c01\\production";
        this.dbDir = "D:\\proalpha\\proalpha-data\\proalpha-de-71c01\\production\\db";
        this.assembliesDir = "D:\\proalpha\\proalpha\\proalpha-de-71c01\\production\\runtime\\pool-a\\res\\advancedgui";
        this.dlcDir = "C:\\Program Files (x86)\\dlc117";
        this.objDir = "D:\\proalpha\\proalpha\\proalpha-de-71c01\\production\\runtime\\pool-a\\obj";
        this.tempDir = "D:\\proalpha\\proalpha\\proalpha-de-71c01\\production\\temp";
        this.repositorUrl = "http://wei-vsagit01:8080/gitblit/r/proalpha.git";
        this.jiraUrl = "http://wei-vsjira01:8080";
        this.jiraProject = "jira-Project";
        this.consistencyChecksLocation = "c:\\Temp\\";
        this.project = "proalpha-de-71c01";
        this.version = "71c01";
        this.enviroment = "production";
        this.testProject = new ConfigurePdsProject(this.project, this.version, this.enviroment, this.startParameter, this.linkedFolderList, this.dbProperties, this.proPath, this.projectDir, this.dbDir, this.assembliesDir, this.dlcDir, this.objDir, this.tempDir, this.jiraUrl, this.jiraProject, this.consistencyChecksLocation, this.enviroment);
    }

    @After
    public void tearDown() {
        this.startParameter = "";
        this.linkedFolderList = "";
        this.appserversList = "";
        this.dbProperties = "";
        this.proPath = "";
        this.projectDir = "";
        this.dbDir = "";
        this.assembliesDir = "";
        this.dlcDir = "";
        this.objDir = "";
        this.tempDir = "";
        this.testProject = null;
    }

    @Test
    public void test() {
        try {
            this.testProject.installPaProject();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        for (IProject p : projects) {
            System.out.println(p.getName());
            if (!p.getName().equals("proalpha-de-71c01-demo")) continue;
            Assert.assertEquals((Object)p.getName(), (Object)"proalpha-de-71c01-demo");
            return;
        }
    }

    @Test
    public void test2() {
        String startParameter = "-pf D:\\Projekte\\proalpha\\71c03\\proalpha\\startup\\client\\demo\\pastartui.pf -ininame \"SOFTWARE\\pSAG\\proalpha\\71c03\\client-demo\" -param \"ConfigFile=D:\\Projekte\\proalpha\\71c03\\proalpha\\startup\\client\\demo\\pastart.xml,SessionType=Dev-Col-MU,UserID=System,Password=compakt\" -Mm 16384";
        String linkedFolderList = "D:\\proALPHA\\pa\\71c\\src";
        String appserversList = "proalpha-de-71c01-production-a-cal,proalpha-de-71c01-production-a-cal-lic,proalpha-de-71c01-production-a-dms,proalpha-de-71c01-production-a-sas,proalpha-de-71c01-production-a-sfi,proalpha-de-71c01-production-sfe,proalpha-de-71c01-production-sfin";
        String dbProperties = "D:\\Projekte\\proalpha\\71c03\\dbconnection.properties";
        String proPath = "D:\\Projekte\\proalpha\\71c03\\propath.txt";
        String projectDir = "D:\\Projekte\\proalpha\\71c03\\proalpha";
        String dbDir = "D:\\Projekte\\proalpha\\71c03\\proalpha-data\\demo\\db";
        String assembliesDir = "D:\\Projekte\\proalpha\\71c03\\proalpha\\res\\advancedgui";
        String dlcDir = "C:\\Program Files (x86)\\dlc117";
        String objDir = "D:\\Projekte\\proalpha\\71c03\\proalpha\\pa\\obj\\demo";
        String tempDir = "D:\\Projekte\\proalpha\\71c03\\proalpha\\temp\\demo";
        String repositoryUrl = "TestRepo";
        String jiraUrl = "jiraUrl";
        String jiraProject = "jira-Projekt";
        String project = "proalpha-de-71c01";
        String version = "71c01";
        String enviroment = "production";
        String consistencyChecksLocation = "TestConsistencyCheck";
        ConfigurePdsProject testProject = new ConfigurePdsProject(project, version, enviroment, startParameter, linkedFolderList, dbProperties, proPath, projectDir, dbDir, assembliesDir, dlcDir, objDir, tempDir, jiraUrl, jiraProject, consistencyChecksLocation, enviroment);
        try {
            testProject.installPaProject();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.toString());
        }
        List<IProject> projects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        for (IProject p : projects) {
            System.out.println(p.getName());
            if (!p.getName().equals("proalpha-de-71c03-demo")) continue;
            Assert.assertEquals((Object)p.getName(), (Object)"proalpha-de-71c03-demo");
            return;
        }
    }

    @Test
    public void checkRepositoryUrlIsSet() throws CoreException, IOException {
        this.testProject.configureMylyn("http://wei-vsjira01:8080", "proAlpha", this.jiraProject, "testUser", "Mir zugewiesene Vorg\u00e4nge");
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        HashSet<String> repositoryUrlSet = new HashSet<String>();
        for (TaskRepository taskRepository : repositories) {
            repositoryUrlSet.add(taskRepository.getRepositoryUrl());
        }
        String expected = "http://wei-vsjira01:8080";
        Assert.assertTrue((boolean)repositoryUrlSet.contains(expected));
    }

    @Test
    public void checkRepositoryLabelIsSet() throws CoreException, IOException {
        this.testProject.configureMylyn(this.jiraUrl, "proAlpha", "proALPHA JIRA", "testUser", "Mir zugewiesene Vorg\u00e4nge");
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        HashSet<String> repositoryLabelSet = new HashSet<String>();
        for (TaskRepository taskRepository : repositories) {
            repositoryLabelSet.add(taskRepository.getRepositoryLabel());
        }
        String expected = "proALPHA JIRA";
        Assert.assertTrue((boolean)repositoryLabelSet.contains(expected));
    }

    @Test
    public void checkRepositoryCategoryIsSet() {
        try {
            this.testProject.configureMylyn(this.jiraUrl, "proAlpha", this.jiraProject, "testUser", "Mir zugewiesene Vorg\u00e4nge");
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        HashSet<String> repositoryCategorySet = new HashSet<String>();
        for (TaskRepository taskRepository : repositories) {
            repositoryCategorySet.add(taskRepository.getCategory());
        }
        String expected = "proAlpha";
        Assert.assertTrue((boolean)repositoryCategorySet.contains(expected));
    }

    @Test
    public void checkRepositoryCredentialsAreSet() {
        try {
            this.testProject.configureMylyn(this.jiraUrl, "proAlpha", this.jiraProject, "testUser", "Mir zugewiesene Vorg\u00e4nge");
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        HashSet<AuthenticationCredentials> credentialsSet = new HashSet<AuthenticationCredentials>();
        for (TaskRepository taskRepository : repositories) {
            credentialsSet.add(taskRepository.getCredentials(AuthenticationType.REPOSITORY));
        }
        String expectedUsername = "testUser";
        String expectedPassword = "";
        if (credentialsSet.size() != 1) {
            Assert.fail((String)"There must be only one authentication credentials set!");
        }
        for (AuthenticationCredentials authenticationCredentials : credentialsSet) {
            Assert.assertEquals((Object)expectedUsername, (Object)authenticationCredentials.getUserName());
            Assert.assertEquals((Object)expectedPassword, (Object)authenticationCredentials.getPassword());
        }
    }

    @Test
    public void checkRepositoryIsAdded() {
        String repositoryUrl = "http://wei-vsjira01:8080";
        String category = "proAlpha";
        String userName = "testUser";
        String repositorySummary = "Mir zugewiesene Vorg\u00e4nge";
        try {
            this.testProject.configureMylyn(repositoryUrl, category, this.jiraProject, userName, repositorySummary);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        TaskRepository expected = new TaskRepository("jira", repositoryUrl);
        expected.setCategory(category);
        expected.setRepositoryLabel(this.jiraProject);
        expected.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        TasksUi.getRepositoryManager().addRepository(expected);
        Set repositories = TasksUi.getRepositoryManager().getRepositories("jira");
        for (TaskRepository actual : repositories) {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void checkRepositoryIsAddedOnlyOnce() {
        String category = "proAlpha";
        String userName = "testUser";
        String repositorySummary = "Mir zugewiesene Vorg\u00e4nge";
        try {
            this.testProject.configureMylyn(this.jiraUrl, category, this.jiraProject, userName, repositorySummary);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        TaskRepository expected = new TaskRepository("jira", this.jiraUrl);
        expected.setCategory(category);
        expected.setRepositoryLabel(this.jiraProject);
        expected.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        TasksUi.getRepositoryManager().addRepository(expected);
        TasksUi.getRepositoryManager().addRepository(expected);
        List repositories = TasksUi.getRepositoryManager().getAllRepositories();
        int repositoryCounter = 0;
        for (TaskRepository actual : repositories) {
            if (actual.getUrl() != this.jiraUrl) continue;
            ++repositoryCounter;
        }
        int expectedRepositoryCounter = 1;
        Assert.assertEquals((long)expectedRepositoryCounter, (long)repositoryCounter);
    }

    @Test
    public void checkRepositoryQueryAddedMoreThenOnceThrowsException() {
        String category = "proAlpha";
        String userName = "testUser";
        String repositorySummary = "Mir zugewiesene Vorg\u00e4nge";
        try {
            this.testProject.configureMylyn(this.jiraUrl, category, this.jiraProject, userName, repositorySummary);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        TaskRepository repository = new TaskRepository("jira", this.jiraUrl);
        repository.setCategory(category);
        repository.setRepositoryLabel(this.jiraProject);
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        TasksUi.getRepositoryManager().addRepository(repository);
        RepositoryQuery repQuery = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(repository);
        repQuery.setSummary(repositorySummary);
        TasksUiPlugin.getTaskList().addQuery(repQuery);
        try {
            TasksUiPlugin.getTaskList().addQuery(repQuery);
        }
        catch (Exception actual) {
            Assert.assertTrue((boolean)(actual instanceof IllegalArgumentException));
        }
    }

    @Test
    public void checkRepositoryQuerySummaryIsSet() {
        String category = "proAlpha";
        String userName = "testUser";
        String expected = "Mir zugewiesene Vorg\u00e4nge";
        try {
            this.testProject.configureMylyn(this.jiraUrl, category, this.jiraProject, userName, expected);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        TaskRepository repository = new TaskRepository("jira", this.jiraUrl);
        repository.setCategory(category);
        repository.setRepositoryLabel(this.jiraProject);
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(userName, ""), true);
        TasksUi.getRepositoryManager().addRepository(repository);
        RepositoryQuery repQuery = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(repository);
        repQuery.setSummary(expected);
        TasksUiPlugin.getTaskList().addQuery(repQuery);
        Set repQueries = TasksUiPlugin.getTaskList().getRepositoryQueries(this.jiraUrl);
        for (RepositoryQuery repositoryQuery : repQueries) {
            Assert.assertEquals((Object)expected, (Object)repositoryQuery.getSummary());
        }
    }
}

