/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.importWizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ReadDemasFile {
    private static final String[] iniprops = new String[]{"appserverslist", "assembliesDir", "buildFileDir", "clientFolderProAlphaMaster", "clientfolderdb", "clientfolderproalpha", "dbConnectionProperties", "dlc", "environment", "gitProjectRepository", "isInstallCry", "isPatchLevelInstallation", "jiraProject", "jiraURL", "linkedFolderList", "masterVersionList", "objDir", "propathTemplate", "project", "startParameter", "subversionlist", "tempDir", "version", "consistencychecks.location"};
    private String ininame = "";
    private boolean validIni = false;
    private String missingField = "";
    private Map<String, String> iniParams = new HashMap<String, String>();

    public ReadDemasFile(String ininame) {
        this.ininame = ininame;
        this.checkIni();
    }

    public boolean isValidIni() {
        return this.validIni;
    }

    public String getmissingField() {
        return this.missingField;
    }

    public String getIniname() {
        return this.ininame;
    }

    public String getProject() {
        return this.iniParams.get("project");
    }

    public String getVersion() {
        return this.iniParams.get("version");
    }

    public String getEnvironment() {
        return this.iniParams.get("environment");
    }

    public String getDbConnectionProperties() {
        return this.iniParams.get("dbConnectionProperties");
    }

    public String getClientfolderproalpha() {
        return this.iniParams.get("clientfolderproalpha");
    }

    public String getClientfolderdb() {
        return this.iniParams.get("clientfolderdb");
    }

    public String getSubversionlist() {
        return this.iniParams.get("subversionlist");
    }

    public String getAssembliesDir() {
        return this.iniParams.get("assembliesDir");
    }

    public String getAppserverslist() {
        return this.iniParams.get("appserverslist");
    }

    public String getStartParameter() {
        return this.iniParams.get("startParameter");
    }

    public String getIsInstallCry() {
        return this.iniParams.get("isInstallCry");
    }

    public String getClientFolderProAlphaMaster() {
        return this.iniParams.get("clientFolderProAlphaMaster");
    }

    public String getMasterVersionList() {
        return this.iniParams.get("masterVersionList");
    }

    public String getLinkedFolderList() {
        return this.iniParams.get("linkedFolderList");
    }

    public String getBuildFileDir() {
        return this.iniParams.get("buildFileDir");
    }

    public String getPropathTemplate() {
        return this.iniParams.get("propathTemplate");
    }

    public String getIsPatchLevelInstallation() {
        return this.iniParams.get("isPatchLevelInstallation");
    }

    public String getTempDir() {
        return this.iniParams.get("tempDir");
    }

    public String getObjDir() {
        return this.iniParams.get("objDir");
    }

    public String getDlc() {
        return this.iniParams.get("dlc");
    }

    public String getRepositoryUrl() {
        return this.iniParams.get("gitProjectRepository");
    }

    public String getJiraUrl() {
        return this.iniParams.get("jiraURL");
    }

    public String getJiraProject() {
        return this.iniParams.get("jiraProject");
    }

    public String getConsistencyChecksLocation() {
        return this.iniParams.get("consistencychecks.location");
    }

    public String[] getIniProperties() {
        return iniprops;
    }

    public String getFullProjectName() {
        return String.valueOf(this.getProject()) + "-" + this.getVersion() + "-" + this.getEnvironment();
    }

    private void checkIni() {
        File file = new File(this.ininame);
        if (!file.exists()) {
            this.validIni = false;
            return;
        }
        this.validIni = this.readAndCheckIni();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readAndCheckIni() {
        keyname = "";
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                fileInput = new FileInputStream(this.ininame);
                try {
                    properties = new Properties();
                    properties.load(fileInput);
                    i = 0;
                    while (true) {
                        keyname = ReadDemasFile.iniprops[i];
                        if (!properties.containsKey(keyname)) {
                            this.missingField = keyname;
                            return false;
                        }
                        this.iniParams.put(keyname, properties.getProperty(keyname));
                        ++i;
                        return (boolean)i;
                    }
                }
                finally {
                    if (i < ReadDemasFile.iniprops.length) ** continue;
                    return true;
                }
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

