/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.proalpha.pds.generator.ContentWriter;
import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.paconnector.userexit.UserExitDelegate;
import com.proalpha.pds.paconnector.userexit.UserExitInclude;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.templates.helper.IDEUtils;
import com.proalpha.pds.templates.jaxb.JaxUnmarshallerGeneric;
import com.proalpha.pds.templates.jaxb.TtUserExits;
import com.proalpha.pds.templates.jet.IpaTemplateGenerator;
import com.proalpha.pds.templates.jet.JetTemplateFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UserExitFileGenerator {
    private static final String TEMPLATE_GENERATOR = "pAUserExitIncludeFile";
    private List<TtUserExits.TtUserExitsRow> definedUserExits;
    private final IGeneratorDataContainer dataContrainer;
    private final UserExitDelegate userExitDelegate;

    public UserExitFileGenerator(IGeneratorDataContainer dataContainer, UserExitDelegate userExitDelegate) throws Exception {
        this.dataContrainer = dataContainer;
        this.userExitDelegate = userExitDelegate;
        this.initializeGenerator();
    }

    private void initializeGenerator() throws Exception {
        String fileName = this.dataContrainer.getFileName();
        String customLevel = this.dataContrainer.getCustomLevel();
        String parentObject = this.dataContrainer.getParentObject();
        String xBaseName = this.calculateXBaseName(fileName, customLevel);
        this.dataContrainer.setFileName(xBaseName);
        String description = String.format("UserExits in %s %s %s", parentObject, System.getProperties().getProperty("line.separator"), this.dataContrainer.getObjectInfo());
        this.dataContrainer.setDescription(description.toString());
        String userExitSortCase = this.dataContrainer.getSortCase();
        UserExitInclude userExitInclude = this.userExitDelegate.getEmptyUserExitInclude();
        userExitInclude.setName(xBaseName);
        userExitInclude.setIncludeType(String.valueOf(customLevel) + "X");
        userExitInclude.setSourceFileName(parentObject);
        userExitInclude.setSortCase(userExitSortCase);
        File userExitXMLFile = this.userExitDelegate.extractUserExitToXMLFile(userExitInclude);
        this.definedUserExits = this.readUserExitFormStandardFile(userExitXMLFile);
        this.dataContrainer.setUserExits(this.definedUserExits);
    }

    private String calculateXBaseName(String fileName, String customLevel) throws Exception {
        if (fileName.contains(".")) {
            return String.valueOf(fileName.substring(0, fileName.lastIndexOf("."))) + this.getFileExtension(fileName, customLevel);
        }
        throw new Exception("Could not calculate XBaseName, invalid filename " + fileName);
    }

    private String getFileExtension(String fileName, String customLevel) throws Exception {
        String fileExtension = "";
        if (fileName.endsWith(".p")) {
            fileExtension = "." + customLevel.toLowerCase() + "xp";
        } else if (fileName.endsWith(".w")) {
            fileExtension = "." + customLevel.toLowerCase() + "xw";
        } else if (fileName.endsWith(".lib")) {
            fileExtension = "." + customLevel.toLowerCase() + "xl";
        } else if (fileName.endsWith(".if") || fileName.endsWith(".i")) {
            fileExtension = "." + customLevel.toLowerCase() + "xi";
        } else if (fileName.endsWith(".tdf")) {
            fileExtension = "." + customLevel.toLowerCase() + "xt";
        } else if (fileName.endsWith(".pds")) {
            fileExtension = "." + customLevel.toLowerCase() + "xp";
        } else if (fileName.endsWith(".fld")) {
            fileExtension = "." + customLevel.toLowerCase() + "xf";
        } else if (fileName.endsWith(".cdf")) {
            fileExtension = "." + customLevel.toLowerCase() + "xc";
        }
        if (fileExtension.isEmpty()) {
            throw new Exception("Could not calculate file extension for file " + fileName);
        }
        return fileExtension;
    }

    private List<TtUserExits.TtUserExitsRow> readUserExitFormStandardFile(File userExitXMLFile) throws JAXBException {
        if (!userExitXMLFile.exists()) {
            throw new JAXBException("Could not generate UserExits: " + userExitXMLFile.getAbsolutePath());
        }
        JaxUnmarshallerGeneric<TtUserExits> jaxb = new JaxUnmarshallerGeneric<TtUserExits>(TtUserExits.class);
        TtUserExits userExits = jaxb.readXMLFile(userExitXMLFile);
        if (userExits == null) {
            throw new JAXBException("Error Reading XML File " + userExitXMLFile.getAbsolutePath());
        }
        return userExits.getTtUserExitsRow();
    }

    public void generate() throws Exception {
        String fileName = this.dataContrainer.getFileName();
        if (this.isUserExitIncludeNew(fileName)) {
            this.createNewUserExitInclude();
        } else {
            this.refreshUserExitInclude();
        }
    }

    private boolean isUserExitIncludeNew(String fileName) {
        File f = new File(fileName);
        return f.exists() && !f.isDirectory();
    }

    public void generateUserExitClassAndBalpEntry() throws Exception {
        this.generate();
        GeneratorFactory.createBalpGenerator(this.dataContrainer).generate();
    }

    private void refreshUserExitInclude() throws Exception {
        if (this.confirmRefresh()) {
            File userExitIncludeFile = this.dataContrainer.getOutputFile().getLocation().toFile();
            Set<String> availableUserExits = this.readUserExitsFormIncludeFile(userExitIncludeFile);
            TreeSet<String> oldUserExits = new TreeSet<String>();
            TreeSet<String> specialUserExits = new TreeSet<String>();
            for (TtUserExits.TtUserExitsRow row : this.definedUserExits) {
                oldUserExits.add(row.getUserExitName().toUpperCase());
                if (!row.isIsSpecialUserExit().booleanValue()) continue;
                specialUserExits.add(row.getUserExitName().toUpperCase());
            }
            TreeSet<String> newUserExits = new TreeSet<String>((Collection<String>)oldUserExits);
            newUserExits.removeAll(availableUserExits);
            newUserExits.removeAll(specialUserExits);
            TreeSet<String> removedUserExits = new TreeSet<String>(availableUserExits);
            removedUserExits.removeAll(oldUserExits);
            this.writeUserExitsInclude(this.dataContrainer.getOutputFile(), newUserExits);
            if (newUserExits.size() > 0) {
                this.displayMessageBox("Exits " + ((Object)newUserExits).toString() + " added.");
            }
            if (removedUserExits.size() > 0) {
                this.displayMessageBox("Exits " + ((Object)removedUserExits).toString() + " removed.");
            }
        }
    }

    private void displayMessageBox(String message) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Refresh UserExit Include", (String)message);
    }

    private void writeUserExitsInclude(IFile outputFile, Set<String> newUserExits) throws Exception {
        File includeFile = this.dataContrainer.getOutputFile().getLocation().toFile();
        BufferedReader reader = new BufferedReader(new FileReader(includeFile));
        String line = null;
        StringBuilder outputBuilder = new StringBuilder();
        Integer insertOffset = -1;
        String lineSeparator = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            if (!this.isUserExitDefinition(line)) {
                outputBuilder.append(String.valueOf(line) + lineSeparator);
                continue;
            }
            if (insertOffset >= 0) continue;
            insertOffset = outputBuilder.length();
        }
        reader.close();
        if (insertOffset > 0) {
            IpaTemplateGenerator paUserExitDefinitins = JetTemplateFactory.getFactoryInstance(this.dataContrainer.getVersion()).getTemplate("paUserExitDefinitions");
            String generatetUserExits = paUserExitDefinitins.generate(this.dataContrainer.getDataAsMap());
            outputBuilder.insert((int)insertOffset, String.valueOf(generatetUserExits) + lineSeparator);
        }
        insertOffset = outputBuilder.lastIndexOf("/* _UIB-CODE-BLOCK-END */");
        String outputString = "";
        for (String newUserExit : newUserExits) {
            String beginDef = String.valueOf(String.format("&IF DEFINED(%s) = 2 &THEN", newUserExit.toUpperCase())) + lineSeparator;
            String endDef = String.valueOf(String.format("&ENDIF /* %s */", newUserExit.toUpperCase())) + lineSeparator;
            outputString = String.valueOf(outputString) + beginDef + lineSeparator + endDef + lineSeparator;
        }
        outputBuilder.insert((int)insertOffset, outputString);
        new ContentWriter(includeFile, outputBuilder.toString()).writeContentToHarddisk();
        IDEUtils.openFileInEditor((IProgressMonitor)new NullProgressMonitor(), outputFile);
    }

    private boolean isUserExitDefinition(String line) {
        Pattern pattern = Pattern.compile("(?i)\\s*&GLOB \\{&PA-XBASISNAME\\}_.*");
        Matcher m = pattern.matcher(line);
        return m.matches();
    }

    private Set<String> readUserExitsFormIncludeFile(File includeFile) throws IOException {
        TreeSet<String> resultSet = new TreeSet<String>();
        LineIterator iterator = FileUtils.lineIterator((File)includeFile);
        try {
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                if (!this.isUserExitDefinition(line)) continue;
                String tempStr = line.replaceAll("\\s*&GLOB \\{&PA-XBASISNAME\\}_", "");
                String userExitName = tempStr.substring(0, tempStr.indexOf(" ")).toUpperCase();
                resultSet.add(userExitName);
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
        return resultSet;
    }

    private boolean confirmRefresh() {
        return this.dataContrainer.isGenerationConfirmed();
    }

    private void createNewUserExitInclude() throws Exception {
        IJobManager jobManager = Job.getJobManager();
        jobManager.join((Object)"com.proalpha.java.oea.plugins.generator.AbstractGenerator", (IProgressMonitor)new NullProgressMonitor());
    }
}

