/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.wizards.controller;

import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLInterfaceFileGenerator;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.templates.wizards.controller.paWizard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class OOABLInterface
extends paWizard
implements INewWizard {
    private static final String INTERFACE_EXTENSION_CLS = "cls";
    private static final String OOABL_WIZARD_DESCRIPTION = "This wizard creates a new proALPHA Interface File.";
    private static final String OOABL_WIZARD_TITLE = "proALPHA Interface File";
    private static final String STD_INTERFACE_SUFFIX = "Std.";
    private static final String CUSTOM_INTERFACE_SUFFIX_PATTERN = "Std.cls|.cls";
    private static final String POINT_TO_INTERFACE_SUFFIX = ".";
    private static final String OOABL_STD_PARENTINTERFACE = "OOABL";
    private static final String STANDARD_LEVEL = "";
    private static final String I_DIGIT = "I";
    private String currentCustomLevel;

    public OOABLInterface() {
        try {
            ArrayList<String> ExtensionList = new ArrayList<String>();
            ExtensionList.add(INTERFACE_EXTENSION_CLS);
            this.setExtensionList(ExtensionList);
            this.setWizardTitle(OOABL_WIZARD_TITLE);
            this.setWizardDescription(OOABL_WIZARD_DESCRIPTION);
            this.setCheckRepository(true);
            this.setParentClass(OOABL_STD_PARENTINTERFACE);
            this.setSupportRepositoryCreateButton(true);
            this.setThirdDigit(I_DIGIT);
            this.setCheckFileNameLength(false);
            this.setCheckLowerCase(false);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    private Map<String, Object> cloneWizardSettings() {
        HashMap<String, Object> exitFileGeneratorSettings = new HashMap<String, Object>();
        for (Map.Entry entry : this.wizardSettings.entrySet()) {
            exitFileGeneratorSettings.put((String)entry.getKey(), entry.getValue());
        }
        return exitFileGeneratorSettings;
    }

    @Override
    protected boolean doFinish() {
        try {
            this.generatorMainInterfaceAndStdInterface();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void generatorMainInterfaceAndStdInterface() throws Exception {
        String fileName = (String)this.wizardSettings.get("FileName");
        fileName = this.getCurrentCustomLevel().equals(STANDARD_LEVEL) && !fileName.endsWith("Std.cls") ? fileName.replace(POINT_TO_INTERFACE_SUFFIX, STD_INTERFACE_SUFFIX) : fileName.replaceAll(CUSTOM_INTERFACE_SUFFIX_PATTERN, String.valueOf(this.getCurrentCustomLevel()) + POINT_TO_INTERFACE_SUFFIX);
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel());
        this.wizardSettings.put("CustomFileName", fileName);
        this.wizardSettings.put("StandardFileName", fileName);
        this.setTemplateGenerator("pAOOABLInterface");
        IGeneratorDataContainer datacontainer = DataContainerFactory.createDataContainer(this.cloneWizardSettings());
        OOABLInterfaceFileGenerator oOABLInterface = GeneratorFactory.createOOABLInterfaceFileGenerator(datacontainer, "pAOOABLStdInterface");
        oOABLInterface.generate();
        super.doFinish();
    }

    public void setCurrentCustomLevel(String currentCustomLevel) {
        this.currentCustomLevel = currentCustomLevel;
    }

    public String getCurrentCustomLevel() {
        if (this.currentCustomLevel != null && this.currentCustomLevel.length() > 0) {
            return this.currentCustomLevel;
        }
        return this.getStartparameterReader().getCurrentCustomLevel();
    }
}

