/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.controller;

import com.proalpha.pds.paconnector.repository.Dataset;
import com.proalpha.pds.ui.wizards.controller.PaWizard;
import com.proalpha.pds.ui.wizards.wizardpages.DatasetDefinitionFilePropertyPage;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import com.proalpha.pds.ui.wizards.wizardpages.WizardpageFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;

public class DatasetDefinitionFile
extends PaWizard
implements INewWizard {
    private DatasetDefinitionFilePropertyPage wizardPDSPropPage;

    public DatasetDefinitionFile() {
        try {
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.add("pds");
            WizardMainPageConfiguration configuration = new WizardMainPageConfiguration();
            configuration.setWizardTitle("proALPHA Dataset Definition File");
            configuration.setWizardDescription("This wizard creates a new proALPHA Dataset Definition File.");
            configuration.setTemplateName("pADatasetDefinitionFile");
            configuration.setExtensionList(extensionList);
            configuration.setRootClass("");
            configuration.setThirdDigit("_");
            configuration.setCheckRepository(false);
            configuration.setSupportRepositoryCreateButton(false);
            configuration.setCheckFileNameLength(true);
            configuration.setCheckLowerCase(true);
            LinkedHashMap<String, WizardMainPageConfiguration> configList = new LinkedHashMap<String, WizardMainPageConfiguration>();
            configList.put("proALPHA Dataset", configuration);
            this.setConfigList(configList);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    @Override
    public void addPages() {
        this.wizardPDSPropPage = WizardpageFactory.createDatasetDefinitionFilePropertyPage(this.getConfigList(), this.getRepositoryDelegate(), this.getRepositoryInformations());
        this.addPage((IWizardPage)this.wizardPDSPropPage);
        super.addPages();
        this.wizardPDSPropPage.setWizardMainPage(this.wizardMainPage);
    }

    @Override
    protected boolean doFinish() {
        this.wizardSettings.putAll(this.wizardPDSPropPage.getSettings());
        if (this.wizardPDSPropPage.getCreateDataset()) {
            if (!this.getbridge().isproALPHAAvailable()) {
                this.wizardMainPage.setErrorMessage("pA not available");
                return false;
            }
            Dataset dataset = this.getRepositoryDelegate().getEmptyDataset();
            dataset.setName((String)this.wizardSettings.get("DatasetName"));
            dataset.setDescription((String)this.wizardSettings.get("Description"));
            dataset.setFileName((String)this.wizardSettings.get("FileName"));
            dataset.setBussinessEntityObject((String)this.wizardSettings.get("BusinessEntityObject"));
            dataset.setDataAccessObject((String)this.wizardSettings.get("DataAccessObject"));
            dataset.setDatabussinessEntityProxy((String)this.wizardSettings.get("BusinessEntityProxy"));
            dataset.setReadOnly((String)this.wizardSettings.get("ReadOnly"));
            dataset.setMasterDataValidation((String)this.wizardSettings.get("MasterDataValidation"));
            dataset.setGetChanges((String)this.wizardSettings.get("GetChanges"));
            if (!this.getRepositoryDelegate().createRepositoryEntryForDataset(dataset)) {
                this.wizardMainPage.setErrorMessage("Failed to create Repository Entry for Dataset \"" + this.wizardSettings.get("DatasetName") + "\"");
                return false;
            }
        }
        return super.doFinish();
    }
}

