/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.generator.UserExitFileGenerator;
import com.proalpha.pds.paconnector.ProjectHandler;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.Activator;
import com.proalpha.pds.ui.ProjectFinder;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;

public class UserExitGeneratorHandler
extends AbstractHandler {
    private DataContainerFactory dataContainerFactory = new DataContainerFactory();
    private GeneratorFactory generatorFactory;
    private ProjectHandler handler = new ProjectHandler();
    private ParameterFactory parameterFactory;

    public UserExitGeneratorHandler() {
        this.generatorFactory = new GeneratorFactory(this.handler);
        this.parameterFactory = new ParameterFactory();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAVMClient runtime;
        OEProject currProj = ProjectFinder.getOEProjectByTextSelection();
        if (currProj != null && (runtime = currProj.getRuntime()) != null) {
            this.generateUserExits((IOpenEdgeProject)currProj);
        }
        return null;
    }

    private void generateUserExits(IOpenEdgeProject openEdgeProject) {
        IRunnableWithProgress runnable = monitor -> {
            try {
                monitor.beginTask("Generate Userexit", 4);
                monitor.worked(1);
                IGeneratorDataContainer datacontainer = this.dataContainerFactory.createDataContainer(openEdgeProject);
                RunProgramInPa paBridge = new RunProgramInPa(openEdgeProject);
                StartparameterReader pAStartParam = this.parameterFactory.createStartparameterReader((OEProject)openEdgeProject);
                String pAProcedure = ProjectFinder.getCurrentFileFromEditor().getName();
                monitor.worked(2);
                datacontainer.setFileName(pAProcedure);
                datacontainer.setVersion(paBridge.getProALPHAVersion());
                datacontainer.setCustomLevel(paBridge.getpAStartupParam("customlevel", ""));
                datacontainer.setObjectInfo(datacontainer.getRepositoryInformations().getProgramShortDesc(pAProcedure));
                if (pAProcedure.endsWith(".cls")) {
                    String pAParentClaasObj = datacontainer.getRepositoryInformations().getClassOBJ(pAProcedure);
                    datacontainer.setParentObject(datacontainer.getRepositoryInformations().getClassName(pAParentClaasObj));
                    OOABLExitFileGenerator gen = this.generatorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdClass");
                    gen.generateUserExitClassAndBalpEntry();
                } else {
                    datacontainer.setParentObject(pAProcedure);
                    UserExitFileGenerator gen = this.generatorFactory.createUserExitFileGenerator(datacontainer);
                    gen.generateUserExitClassAndBalpEntry();
                }
                monitor.worked(2);
                pAStartParam.getWorkingDirectory().refreshLocal(2, monitor);
                monitor.done();
            }
            catch (Exception exception) {
                ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)exception);
            }
        };
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)rule);
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        catch (InterruptedException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

