/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.model.filter;

import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ComponentFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.CurrentUserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateRangeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.EstimateVsActualFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDataExtractor;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueTypeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.JiraFieldSpecialValue;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.NobodyFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ProjectFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.RelativeDateRangeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ResolutionFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.SpecificUserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserInGroupFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.VersionFilter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class JQLFilterDataExtractor
extends FilterDataExtractor {
    @Override
    public Collection<String> extractAssignedTo(UserFilter userFilter) {
        return this.extractUsers(userFilter, JiraFieldSpecialValue.UNASSIGNED.getJql());
    }

    @Override
    public Collection<String> extractComponents(ComponentFilter componentFilter) {
        ArrayList<String> componentIds = new ArrayList<String>();
        if (componentFilter != null) {
            if (componentFilter.hasNoComponent()) {
                componentIds.add(JiraFieldSpecialValue.COMPONENT_NONE.getJql());
            }
            if (componentFilter.getComponents() != null) {
                componentIds.addAll(this.getComponentIds(Arrays.asList(componentFilter.getComponents())));
            }
        }
        return componentIds;
    }

    @Override
    public Collection<String> extractDates(DateFilter dateFilter, DateFormat dateFormat) {
        ArrayList<String> dates = new ArrayList<String>();
        if (dateFilter instanceof DateRangeFilter) {
            DateRangeFilter rangeFilter = (DateRangeFilter)dateFilter;
            if (rangeFilter.getFromDate() != null) {
                dates.add(">= " + JQLFilterDataExtractor.putInDoubleQuotes(dateFormat.format(rangeFilter.getFromDate())));
            }
            if (rangeFilter.getToDate() != null) {
                dates.add("<= " + JQLFilterDataExtractor.putInDoubleQuotes(dateFormat.format(rangeFilter.getToDate())));
            }
            if (rangeFilter.getFrom() != null && rangeFilter.getFrom().length() > 0) {
                dates.add(">= " + JQLFilterDataExtractor.putInDoubleQuotes(rangeFilter.getFrom()));
            }
            if (rangeFilter.getTo() != null && rangeFilter.getTo().length() > 0) {
                dates.add("<= " + JQLFilterDataExtractor.putInDoubleQuotes(rangeFilter.getTo()));
            }
        } else if (dateFilter instanceof RelativeDateRangeFilter) {
            RelativeDateRangeFilter rangeFilter = (RelativeDateRangeFilter)dateFilter;
            if (rangeFilter.previousMilliseconds() != 0L) {
                dates.add(">= " + JQLFilterDataExtractor.putInDoubleQuotes(JQLFilterDataExtractor.createRelativeDateString(rangeFilter.getPreviousRangeType(), rangeFilter.getPreviousCount())));
            }
            if (rangeFilter.nextMilliseconds() != 0L) {
                dates.add("<= " + JQLFilterDataExtractor.putInDoubleQuotes(JQLFilterDataExtractor.createRelativeDateString(rangeFilter.getNextRangeType(), rangeFilter.getNextCount())));
            }
        }
        return dates;
    }

    @Override
    public Collection<String> extractIssueTypes(IssueTypeFilter issueTypeFilter) {
        ArrayList<String> issueTypeNames = new ArrayList<String>();
        if (issueTypeFilter != null) {
            if (issueTypeFilter.isStandardTypes()) {
                issueTypeNames.add(JiraFieldSpecialValue.ISSUE_TYPE_STANDARD.getJql());
            }
            if (issueTypeFilter.isSubTaskTypes()) {
                issueTypeNames.add(JiraFieldSpecialValue.ISSUE_TYPE_SUBTASK.getJql());
            }
            if (issueTypeFilter.getIsueTypes() != null) {
                issueTypeNames.addAll(this.getIssueTypeNames(Arrays.asList(issueTypeFilter.getIsueTypes())));
            }
        }
        return issueTypeNames;
    }

    @Override
    public Collection<String> extractProjects(ProjectFilter projectFilter) {
        if (projectFilter != null && projectFilter.getProjects() != null) {
            return this.getProjectKeys(Arrays.asList(projectFilter.getProjects()));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> extractReportedBy(UserFilter userFilter) {
        return this.extractUsers(userFilter, JiraFieldSpecialValue.ISSUE_NO_REPORTER.getJql());
    }

    @Override
    public Collection<String> extractResolutions(ResolutionFilter resolutionFilter) {
        ArrayList<String> resolutionIds = new ArrayList<String>();
        if (resolutionFilter != null) {
            if (resolutionFilter.isUnresolved()) {
                resolutionIds.add(JiraFieldSpecialValue.UNRESOLVED.getJql());
            }
            if (resolutionFilter.getResolutions() != null) {
                resolutionIds.addAll(this.getResolutionNames(Arrays.asList(resolutionFilter.getResolutions())));
            }
        }
        return resolutionIds;
    }

    @Override
    public Collection<String> extractVersions(VersionFilter filter) {
        ArrayList<String> fixVersionNames = new ArrayList<String>();
        if (filter != null) {
            if (filter.hasNoVersion()) {
                fixVersionNames.add(JiraFieldSpecialValue.VERSION_NONE.getJql());
            }
            if (filter.isReleasedVersions()) {
                fixVersionNames.add(JiraFieldSpecialValue.VERSION_RELEASED.getJql());
            }
            if (filter.isUnreleasedVersions()) {
                fixVersionNames.add(JiraFieldSpecialValue.VERSION_UNRELEASED.getJql());
            }
            if (filter.getVersions() != null) {
                fixVersionNames.addAll(this.getVersionNames(Arrays.asList(filter.getVersions())));
            }
        }
        return fixVersionNames;
    }

    private Collection<String> extractUsers(UserFilter userFilter, String emptyUserName) {
        ArrayList<String> usersOrGroups = new ArrayList<String>();
        if (userFilter != null) {
            if (userFilter instanceof NobodyFilter) {
                usersOrGroups.add(emptyUserName);
            } else if (userFilter instanceof CurrentUserFilter) {
                usersOrGroups.add(JiraFieldSpecialValue.ISSUE_CURRENT_USER.getJql());
            } else if (userFilter instanceof SpecificUserFilter) {
                usersOrGroups.add(((SpecificUserFilter)userFilter).getUser());
            } else if (userFilter instanceof UserInGroupFilter) {
                usersOrGroups.add(String.valueOf(JiraFieldSpecialValue.ISSUE_SPECIFIC_GROUP.getJql()) + "(" + JQLFilterDataExtractor.putInDoubleQuotes(((UserInGroupFilter)userFilter).getGroup()) + ")");
            }
        }
        return usersOrGroups;
    }

    @Override
    public Collection<String> extractWorkRatios(EstimateVsActualFilter estimateFilter) {
        ArrayList<String> workRatios = new ArrayList<String>(2);
        if (estimateFilter != null) {
            long maxVariation;
            long minVariation = estimateFilter.getMinVariation();
            if (minVariation != 0L) {
                workRatios.add(" >= " + minVariation);
            }
            if ((maxVariation = estimateFilter.getMaxVariation()) != 0L) {
                workRatios.add(" <= " + maxVariation);
            }
        }
        return workRatios;
    }
}

