/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.java.oea.plugins.querygenerator.handlers;

import com.openedge.core.runtime.IAVMInputCommandHandler;
import com.openedge.core.runtime.IAVMInputRequest;
import com.proalpha.java.oea.plugins.querygenerator.EditorTools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorInsertCommandHandler
implements IAVMInputCommandHandler {
    private static int requestId = 0;
    private String responseValue = "";

    public String getName() {
        return "InsertTextToEditor";
    }

    public String getResponse() {
        return this.responseValue;
    }

    public boolean needResponse() {
        return true;
    }

    public void processRequest(IAVMInputRequest inputRequest) {
        if (inputRequest == null) {
            return;
        }
        this.responseValue = "";
        Display.getDefault().syncExec((Runnable)new InsertCommand(inputRequest.getMessage()));
    }

    public static int getRequestId() {
        return requestId;
    }

    public static void setRequestId(int requestId) {
        EditorInsertCommandHandler.requestId = requestId;
    }

    private class InsertCommand
    implements Runnable {
        private String insertString = "";

        public InsertCommand(String insertString) {
            this.insertString = insertString;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorPart editorPart = page.getActiveEditor();
            ITextEditor editor = (ITextEditor)editorPart.getAdapter(ITextEditor.class);
            EditorTools.getInstance().insertText(editor, this.insertString);
            window.getShell().setMinimized(false);
            editor.setFocus();
            EditorInsertCommandHandler.this.responseValue = String.format("IDEWindowHandle=%d", window.getShell().handle);
        }
    }
}

