/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.external;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.external.DBAndBinaryWizard;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DbAndBinaryHandler
extends AbstractHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RepositoryTreeNode treenode = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        Repository repository = treenode.getRepository();
        String reference = "";
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (Git git = new Git(repository);){
                Status status = git.status().call();
                if (!status.isClean()) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Repository Status", (String)"Repository is not clean. Operations are permitted! Clean your repository and try again.");
                    return null;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (GitAPIException | NoWorkTreeException e) {
            Activator.logToConsole(String.format("Error in Method getStagedFiles: %s", e.getMessage()));
        }
        try {
            reference = repository.getFullBranch();
            if (Repository.isValidRefName((String)reference)) {
                DBAndBinaryWizard dbwiz = new DBAndBinaryWizard(repository);
                WizardDialog wiz = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)dbwiz);
                wiz.open();
                return null;
            }
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Repository Status", (String)("Reference " + reference + " does not correspond to a branch. Maybe you are in DETACHED HEAD. Check your repository!"));
            return null;
        }
        catch (IOException e) {
            throw new ExecutionException(e.getLocalizedMessage());
        }
    }

    public <T> List<T> getSelectedNodes(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }
}

