/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.parameter;

import java.util.HashMap;
import java.util.Map;

public enum CustomLevel {
    STANDARD("", "", "Std"),
    COUNTRY("C", "C", "C"),
    INDUSTRY("U", "U", "U"),
    COMPONENT("Q", "Q", "Q"),
    PARTNER("X", "X", "X"),
    CUSTOMER("Y", "Y", "Y");

    private static Map<String, CustomLevel> valueMap;
    private static Map<String, CustomLevel> identCharMap;
    private static Map<String, CustomLevel> classSuffixMap;
    private String value = "";
    private String identChar = "";
    private String classSuffix = "";

    static {
        valueMap = null;
        identCharMap = null;
        classSuffixMap = null;
        valueMap = new HashMap<String, CustomLevel>();
        identCharMap = new HashMap<String, CustomLevel>();
        classSuffixMap = new HashMap<String, CustomLevel>();
        CustomLevel[] customLevelArray = CustomLevel.values();
        int n = customLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomLevel customLevel = customLevelArray[n2];
            valueMap.put(customLevel.getValue().toLowerCase(), customLevel);
            identCharMap.put(customLevel.getIdentChar().toLowerCase(), customLevel);
            classSuffixMap.put(customLevel.getClassSuffix().toLowerCase(), customLevel);
            ++n2;
        }
    }

    private CustomLevel(String value, String identChar, String classSuffix) {
        this.value = value;
        this.identChar = identChar;
        this.classSuffix = classSuffix;
    }

    public String getValue() {
        return this.value;
    }

    public String getIdentChar() {
        return this.identChar;
    }

    public String getClassSuffix() {
        return this.classSuffix;
    }

    public boolean isLowerThan(CustomLevel customLevelToCompare) {
        return this.compareTo(customLevelToCompare) < 0;
    }

    public boolean isLowerOrEqualThan(CustomLevel customLevelToCompare) {
        return this.compareTo(customLevelToCompare) <= 0;
    }

    public boolean isHigherThan(CustomLevel customLevelToCompare) {
        return this.compareTo(customLevelToCompare) > 0;
    }

    public boolean isHigherOrEqualThan(CustomLevel customLevelToCompare) {
        return this.compareTo(customLevelToCompare) >= 0;
    }

    public static CustomLevel getByValue(String value) {
        value = value == null ? "" : value.toLowerCase();
        return valueMap.containsKey(value) ? valueMap.get(value) : STANDARD;
    }

    public static CustomLevel getByIdentChar(String identChar) {
        identChar = identChar == null ? "" : identChar.toLowerCase();
        return identCharMap.containsKey(identChar) ? identCharMap.get(identChar) : STANDARD;
    }

    public static CustomLevel getByClassSuffix(String classSuffix) {
        classSuffix = classSuffix == null ? "" : classSuffix.toLowerCase();
        return classSuffixMap.containsKey(classSuffix) ? classSuffixMap.get(classSuffix) : STANDARD;
    }
}

