/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector;

import com.proalpha.pds.paconnector.PaVersion;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PaVersionParser {
    private static final String V9_VERSION_REGEX = "^(?<MajorVersionNo>\\d+)\\.(?<MinorVersionNo>\\d+)\\.(?<PatchNo>\\d+)$";
    private static final Pattern V9_VERSION_PATTERN = Pattern.compile("^(?<MajorVersionNo>\\d+)\\.(?<MinorVersionNo>\\d+)\\.(?<PatchNo>\\d+)$", 2);
    private static final String CONS_VERSION_REGEX = "^(?<MajorVersionNo>\\d{3})(?<MinorVersionNo>\\d{3})(?<PatchNo>\\d{3})$";
    private static final Pattern CONS_VERSION_PATTERN = Pattern.compile("^(?<MajorVersionNo>\\d{3})(?<MinorVersionNo>\\d{3})(?<PatchNo>\\d{3})$", 2);
    private static final String OLD_VERSION_REGEX = "^(?<MajorVersionNo>\\d)\\.?(?<MinorVersionNo>\\d+)(?<PatchChar>[a-z])?(?<BuildNo>\\d{2})?$";
    private static final Pattern OLD_VERSION_PATTERN = Pattern.compile("^(?<MajorVersionNo>\\d)\\.?(?<MinorVersionNo>\\d+)(?<PatchChar>[a-z])?(?<BuildNo>\\d{2})?$", 2);
    private static final Pattern[] VERSIION_PATTERNS = new Pattern[]{V9_VERSION_PATTERN, CONS_VERSION_PATTERN, OLD_VERSION_PATTERN};

    public static PaVersion parseVersionString(String versionString) throws ParseException {
        Matcher matcher = PaVersionParser.versionNumberMatcher(versionString);
        PaVersion version = new PaVersion();
        try {
            if (matcher.group("MajorVersionNo") != null) {
                version.setMajorVersionNo(Integer.valueOf(matcher.group("MajorVersionNo")));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            if (matcher.group("MinorVersionNo") != null) {
                version.setMinorVersionNo(Integer.valueOf(matcher.group("MinorVersionNo")));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            if (matcher.group("PatchNo") != null) {
                version.setPatchNo(Integer.valueOf(matcher.group("PatchNo")));
            }
        }
        catch (IllegalArgumentException epn) {
            try {
                if (matcher.group("PatchChar") != null) {
                    version.setPatchChar(matcher.group("PatchChar").charAt(0));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            if (matcher.group("BuildNo") != null) {
                version.setBuildNo(Integer.valueOf(matcher.group("BuildNo")));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return version;
    }

    private static Matcher versionNumberMatcher(String versionString) throws ParseException {
        Pattern[] patternArray = VERSIION_PATTERNS;
        int n = VERSIION_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Matcher matcher = pattern.matcher(versionString);
            if (matcher.find()) {
                return matcher;
            }
            ++n2;
        }
        throw new ParseException("\"" + versionString + "\" is not a valid Proalpha version number", 0);
    }
}

