/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.proalpha.pds.generator.ContentGenerator;
import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.paconnector.parameter.CustomLevel;
import com.proalpha.pds.paconnector.repository.Instance;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OOABLExitFileGenerator {
    private static final String EMPTY_STRING = "";
    private static final String CLASS_SUFFIX = ".cls";
    private static final String CUSTOM_CLASS_SUFFIX_PATTERN;
    private static final String OOABL_STD_PARENTCLASS = "OOABL";
    private final IGeneratorDataContainer dataContainer;
    private String templateGeneratorName;
    private final RepositoryDelegate repositoryDelegate;
    private final RepositoryInformations repositoryInformations;
    private CustomLevel currentCustomLevel;

    static {
        StringBuilder customLevelStringListBuilder = new StringBuilder();
        customLevelStringListBuilder.append("(?:");
        CustomLevel[] customLevelArray = CustomLevel.values();
        int n = customLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomLevel customLevel = customLevelArray[n2];
            if (customLevelStringListBuilder.length() > 0) {
                customLevelStringListBuilder.append("|");
            }
            customLevelStringListBuilder.append(customLevel.getClassSuffix());
            ++n2;
        }
        customLevelStringListBuilder.append(")?\\.cls");
        CUSTOM_CLASS_SUFFIX_PATTERN = customLevelStringListBuilder.toString();
    }

    public OOABLExitFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName, RepositoryDelegate repositoryDelegate, RepositoryInformations repositoryInformations) {
        this.dataContainer = datacontainer;
        this.templateGeneratorName = templateGeneratorName;
        this.repositoryDelegate = repositoryDelegate;
        this.repositoryInformations = repositoryInformations;
        this.currentCustomLevel = CustomLevel.getByValue((String)this.dataContainer.getCustomLevel());
        this.initializeGenerator();
    }

    private void createObjectInRepository(String parentClass, String fileName, String description) {
        if (this.isStandardCustomLevel() && this.dataContainer.getPaProject().getMajorVersion() < 9) {
            this.showErrorMessage("Unable to create Repository entry", String.format("In x64 PDS we cannot create instances. Please create the missing repository entry for %s manually.", fileName));
            throw new UnsupportedOperationException("x64 PDS");
        }
        try {
            Instance instance = this.repositoryDelegate.getEmptyInstance();
            instance.setName(fileName);
            instance.setShortDescription(description);
            instance.setDescription(EMPTY_STRING);
            instance.setParentClass(parentClass);
            this.repositoryDelegate.createRepositoryEntryforInstance(instance);
        }
        catch (Exception e) {
            this.showErrorMessage("Unable to create File in the Repository", e.getMessage());
        }
    }

    private String getParentObjectFromStandardClass(String standardClass) {
        String parentClass = null;
        if (standardClass != null && standardClass.equals(EMPTY_STRING)) {
            parentClass = this.repositoryInformations.getClassName(this.repositoryInformations.getClassOBJ(standardClass));
        }
        if (parentClass == null || parentClass.equals(EMPTY_STRING)) {
            parentClass = OOABL_STD_PARENTCLASS;
        }
        return parentClass;
    }

    private String getClassName(String fileName) {
        return fileName.replace(CLASS_SUFFIX, EMPTY_STRING);
    }

    private String getDescription(String fileName) {
        Map<String, Object> wizardSettings = this.dataContainer.getWizardSettings();
        StringBuilder sb = new StringBuilder();
        if (this.isStandardCustomLevel()) {
            sb.append("Standard ");
        } else {
            sb.append("Custom ");
        }
        if (wizardSettings.containsKey("TemplateName") && this.isInterface(wizardSettings.get("TemplateName").toString())) {
            sb.append("Interface for ");
        } else {
            sb.append("Class for ");
        }
        sb.append(fileName);
        return sb.toString();
    }

    private String getFileName(String mainClassName) {
        return mainClassName.concat(this.currentCustomLevel.getClassSuffix()).concat(CLASS_SUFFIX);
    }

    private String getMainClassName(String fileName) {
        return fileName.replaceAll(CUSTOM_CLASS_SUFFIX_PATTERN, EMPTY_STRING);
    }

    private String getQualifiedClassName(String className) {
        String packagePath = this.dataContainer.getRelativePath().replace("/", ".");
        String classNameWithoutSuffix = className.replaceAll(CLASS_SUFFIX, EMPTY_STRING);
        return classNameWithoutSuffix.equals(EMPTY_STRING) ? classNameWithoutSuffix : String.valueOf(packagePath) + "." + classNameWithoutSuffix;
    }

    private String getStandardClassIfAvailable(String mainClassName) {
        CustomLevel customLevel = CustomLevel.getByIdentChar((String)mainClassName.substring(0, 1));
        if (customLevel.isHigherOrEqualThan(this.currentCustomLevel)) {
            return mainClassName;
        }
        String standardClass = mainClassName.concat(customLevel.getClassSuffix()).concat(CLASS_SUFFIX);
        return this.isInRepository(standardClass) != false ? standardClass : EMPTY_STRING;
    }

    private String getXBaseName(String fileName) {
        return fileName.replace(".", "_");
    }

    private Boolean isInRepository(String className) {
        return this.repositoryInformations.exitsInstanceInRepository(className);
    }

    private boolean isStandardCustomLevel() {
        return this.currentCustomLevel == CustomLevel.STANDARD;
    }

    private boolean isInterface(String templateName) {
        return templateName.endsWith("Interface");
    }

    private void initializeGenerator() {
        String mainClassName = this.getMainClassName(this.dataContainer.getFileName());
        this.dataContainer.setMainClass(mainClassName);
        String qualifiedMainClassName = this.getQualifiedClassName(mainClassName);
        this.dataContainer.setQualifiedMainClassName(qualifiedMainClassName);
        String fileName = this.getFileName(mainClassName);
        this.dataContainer.setFileName(fileName);
        String xbaseName = this.getXBaseName(fileName);
        this.dataContainer.setXBaseName(xbaseName);
        String className = this.getClassName(fileName);
        String qualifiedClassName = this.getQualifiedClassName(className);
        this.dataContainer.setQualifiedClassName(qualifiedClassName);
        String standardClassName = this.getStandardClassIfAvailable(mainClassName);
        String descriptionClassName = !standardClassName.isEmpty() ? standardClassName : String.valueOf(mainClassName) + CLASS_SUFFIX;
        String description = this.getDescription(descriptionClassName);
        this.dataContainer.setDescription(description);
        if (this.dataContainer.getParentObject().equals(EMPTY_STRING)) {
            String parentObject = this.getParentObjectFromStandardClass(standardClassName);
            this.dataContainer.setParentObject(parentObject);
        }
    }

    private void showErrorMessage(String title, String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    public void generate() throws Exception {
        if (!this.isInRepository(this.dataContainer.getFileName()).booleanValue()) {
            this.createObjectInRepository(this.dataContainer.getParentObject(), this.dataContainer.getFileName(), this.dataContainer.getDescription());
        }
        ContentGenerator generator = new ContentGenerator("OOABL Class Generator", this.dataContainer, this.templateGeneratorName);
        generator.schedule();
        IJobManager jobManager = Job.getJobManager();
        jobManager.join((Object)"com.proalpha.java.oea.plugins.generator.AbstractGenerator", (IProgressMonitor)new NullProgressMonitor());
    }

    public void generateUserExitClassAndBalpEntry() throws Exception {
        this.generate();
        GeneratorFactory generatorFactory = new GeneratorFactory();
        generatorFactory.createBalpGenerator(this.dataContainer).generate();
    }
}

