/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.proalpha.pds.generator.BalpGenerator;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.generator.TriggerFileGenerator;
import com.proalpha.pds.generator.UserExitFileGenerator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryFactory;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.userexit.UserExitDelegate;
import com.proalpha.pds.paconnector.userexit.UserExitFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorFactory {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorFactory.class);
    private RepositoryDelegate repositoryDelegate;
    private RepositoryInformations repositoryInformations;
    private StartparameterReader startparameterReader;
    private UserExitDelegate userExitDelegate;
    private UserExitFactory userExitFactory = new UserExitFactory();

    public BalpGenerator createBalpGenerator(IGeneratorDataContainer datacontainer) throws Exception {
        PaProject paProject = datacontainer.getPaProject();
        UserExitDelegate userExitDelegate = this.getUserExitDelegate(paProject);
        StartparameterReader startparameterReader = this.getStartparameterReader(paProject);
        return new BalpGenerator(datacontainer, userExitDelegate, startparameterReader);
    }

    public OOABLExitFileGenerator createOOABLExitFileGenerator(IGeneratorDataContainer datacontainer, String templateGeneratorName) {
        PaProject paProject = datacontainer.getPaProject();
        RepositoryDelegate repositoryDelegate = this.getRepositoryDelegate(paProject);
        RepositoryInformations repositoryInformations = this.getRepositoryInformations(paProject);
        return new OOABLExitFileGenerator(datacontainer, templateGeneratorName, repositoryDelegate, repositoryInformations);
    }

    public TriggerFileGenerator createTriggerFileGenerator(IGeneratorDataContainer datacontainer) {
        return new TriggerFileGenerator(datacontainer);
    }

    public UserExitFileGenerator createUserExitFileGenerator(IGeneratorDataContainer datacontainer) throws Exception {
        UserExitDelegate userExitDelegate = this.getUserExitDelegate(datacontainer.getPaProject());
        return new UserExitFileGenerator(datacontainer, userExitDelegate);
    }

    private RepositoryDelegate getRepositoryDelegate(PaProject paProject) {
        if (this.repositoryDelegate == null) {
            try {
                RepositoryFactory factory = new RepositoryFactory();
                this.repositoryDelegate = factory.createRepositoryDelegate(paProject);
            }
            catch (ProALPHANotAvailableException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.repositoryDelegate;
    }

    private RepositoryInformations getRepositoryInformations(PaProject paProject) {
        if (this.repositoryInformations == null) {
            try {
                RepositoryFactory factory = new RepositoryFactory();
                this.repositoryInformations = factory.createRepositoryInformations(paProject);
            }
            catch (ProALPHANotAvailableException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.repositoryInformations;
    }

    private StartparameterReader getStartparameterReader(PaProject project) {
        if (this.startparameterReader == null) {
            try {
                ParameterFactory parameterFactory = new ParameterFactory();
                this.startparameterReader = parameterFactory.createStartparameterReader(project);
            }
            catch (ProALPHANotAvailableException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.startparameterReader;
    }

    private UserExitDelegate getUserExitDelegate(PaProject project) {
        if (this.userExitDelegate == null) {
            try {
                this.userExitDelegate = this.userExitFactory.createUserExitDelegate(project, this.getStartparameterReader(project));
            }
            catch (ProALPHANotAvailableException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.userExitDelegate;
    }
}

