/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.repository.DatasetCatalog;
import com.proalpha.pds.paconnector.repository.DatasetCatalogEntry;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.ui.wizards.wizardpages.IpaWizardPage;
import com.proalpha.pds.ui.wizards.wizardpages.PaDatasetCatalogTree;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DatasetCustomizationWizardPage
extends WizardPage
implements IpaWizardPage {
    private static final Color COLOR_DEFAULT_WIDGET_BACKGROUND = Display.getCurrent().getSystemColor(22);
    private static final Color COLOR_YELLOW = Display.getCurrent().getSystemColor(7);
    private static final int DEFAULT_TREE_HEIGHT = 400;
    private PaDatasetCatalogTree datasetTree = null;
    private Text businessEntityObjectText = null;
    private Text dataAccessObjectText = null;
    private RepositoryInformations repositoryInformations = null;

    public DatasetCustomizationWizardPage(LinkedHashMap<String, WizardMainPageConfiguration> config, RepositoryInformations repositoryInformations) {
        super("DatasetCustomizationWizardPage");
        this.repositoryInformations = repositoryInformations;
        this.setTitle("Dataset Customization");
        this.setDescription("Select the dataset you want to customize");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.datasetTree = new PaDatasetCatalogTree(container);
        GridData datasetTreeGridData = new GridData(4, 4, true, true, 2, 1);
        datasetTreeGridData.heightHint = 400;
        this.datasetTree.setLayoutData(datasetTreeGridData);
        this.datasetTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                Object firstElement;
                DatasetCatalogEntry selectedDatasetCatalogEntry = DatasetCustomizationWizardPage.this.getSelectedDatasetCatalogEntry(event.getSelection());
                if (event.getSelection() instanceof IStructuredSelection && (firstElement = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) != null && firstElement instanceof DatasetCatalogEntry) {
                    selectedDatasetCatalogEntry = (DatasetCatalogEntry)firstElement;
                }
                if (selectedDatasetCatalogEntry != null) {
                    DatasetCustomizationWizardPage.this.businessEntityObjectText.setText(selectedDatasetCatalogEntry.getBusinessEntityObjectName());
                    DatasetCustomizationWizardPage.this.businessEntityObjectText.setBackground(selectedDatasetCatalogEntry.isBEOCustomized() ? COLOR_YELLOW : COLOR_DEFAULT_WIDGET_BACKGROUND);
                    DatasetCustomizationWizardPage.this.dataAccessObjectText.setText(selectedDatasetCatalogEntry.getDataAccesObjectName());
                    DatasetCustomizationWizardPage.this.dataAccessObjectText.setBackground(selectedDatasetCatalogEntry.isDAOCustomized() ? COLOR_YELLOW : COLOR_DEFAULT_WIDGET_BACKGROUND);
                    DatasetCustomizationWizardPage.this.setPageComplete(!selectedDatasetCatalogEntry.isCustomDataset());
                } else {
                    DatasetCustomizationWizardPage.this.businessEntityObjectText.setText("");
                    DatasetCustomizationWizardPage.this.businessEntityObjectText.setBackground(COLOR_DEFAULT_WIDGET_BACKGROUND);
                    DatasetCustomizationWizardPage.this.dataAccessObjectText.setText("");
                    DatasetCustomizationWizardPage.this.businessEntityObjectText.setBackground(COLOR_DEFAULT_WIDGET_BACKGROUND);
                    DatasetCustomizationWizardPage.this.setPageComplete(false);
                }
            }
        });
        this.datasetTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!DatasetCustomizationWizardPage.this.isPageComplete()) {
                    return;
                }
                IWizardPage nextPage = DatasetCustomizationWizardPage.this.getNextPage();
                if (nextPage == null) {
                    return;
                }
                DatasetCustomizationWizardPage.this.getWizard().getContainer().showPage(nextPage);
            }
        });
        Label businessEntityObjectLabel = new Label(container, 131072);
        businessEntityObjectLabel.setText("Business Entity Object:");
        this.businessEntityObjectText = new Text(container, 2060);
        this.businessEntityObjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label dataAccessObjectLabel = new Label(container, 131072);
        dataAccessObjectLabel.setText("Data Access Object:");
        this.dataAccessObjectText = new Text(container, 2060);
        this.dataAccessObjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        try {
            DatasetCatalog datasetCatalog = this.repositoryInformations.getDatasetCatalog();
            this.datasetTree.getViewer().setInput((Object)datasetCatalog.getDatasets());
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage(e.getMessage());
        }
        container.computeSize(-1, 400);
        this.setControl((Control)container);
    }

    private DatasetCatalogEntry getSelectedDatasetCatalogEntry(ISelection selection) {
        IStructuredSelection structuredSelection;
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof DatasetCatalogEntry) {
            return (DatasetCatalogEntry)firstElement;
        }
        return null;
    }

    private String getQualifiedDatasetFilename(String datasetFilename) {
        String datasetRelativePath = this.repositoryInformations.getRelativePath(datasetFilename);
        if (datasetRelativePath != null && !datasetRelativePath.isEmpty()) {
            return String.valueOf(datasetRelativePath) + "/" + datasetFilename;
        }
        return datasetFilename;
    }

    @Override
    public Map<String, Object> getSettings() {
        DatasetCatalogEntry selectedDatasetCatalogEntry = this.getSelectedDatasetCatalogEntry(this.datasetTree.getViewer().getSelection());
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        wizardSettings.put("DatasetName", selectedDatasetCatalogEntry.getName());
        wizardSettings.put("DatasetFilename", this.getQualifiedDatasetFilename(selectedDatasetCatalogEntry.getDefinitionFile()));
        wizardSettings.put("IsCustomDataset", selectedDatasetCatalogEntry.isCustomDataset());
        wizardSettings.put("CurrentBeoInstance", selectedDatasetCatalogEntry.getBusinessEntityObjectName());
        wizardSettings.put("IsBEOCustomized", selectedDatasetCatalogEntry.isBEOCustomized());
        wizardSettings.put("CurrentDAOInstance", selectedDatasetCatalogEntry.getDataAccesObjectName());
        wizardSettings.put("IsDaoCustomized", selectedDatasetCatalogEntry.isDAOCustomized());
        return wizardSettings;
    }
}

