/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.model;

import com.progress.tools.reportbug.IProductLog;
import com.progress.tools.reportbug.core.Messages;
import com.progress.tools.reportbug.model.Attachment;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ProductAttachment
extends Attachment {
    private IProductLog productLog;
    private boolean isSelected;

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public ProductAttachment(String pathInZip, IProductLog data) {
        this(pathInZip, data, Messages.ProductAttachment_productLogExtension);
    }

    public ProductAttachment(String pathInZip, IProductLog data, String file) {
        super(String.valueOf(pathInZip) + file);
        this.productLog = data;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public void openStream() {
        try {
            this.productLog.preFinish();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int readChunk(byte[] bytes) {
        int i = -1;
        try {
            i = this.productLog.getInputStream().read(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return i;
    }

    @Override
    public void closeStream() {
        this.productLog.postFinish();
    }
}

