/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.dialogs;

import com.progress.tools.reportbug.IProductLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ViewDetailsDialog
extends TitleAreaDialog {
    private IProductLog log;

    public ViewDetailsDialog(Shell parent, IProductLog log) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.log = log;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        StyledText text = new StyledText(parentComposite, 2888);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        text.setText(this.getContent());
        text.setBackground(Display.getDefault().getSystemColor(1));
        this.setTitle(this.log.getName());
        this.getShell().setText(this.log.getName());
        this.setMessage(this.log.getDescription());
        this.setContextHelp();
        return parent;
    }

    public String getContent() {
        if (this.log != null) {
            StringBuilder sb;
            block7: {
                sb = new StringBuilder();
                try {
                    try {
                        String line;
                        this.log.preFinish();
                        InputStream is = this.log.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        while ((line = reader.readLine()) != null) {
                            sb.append(line).append("\n");
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.log.postFinish();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.log.postFinish();
                    throw throwable;
                }
                this.log.postFinish();
            }
            return sb.toString();
        }
        return "";
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    void setContextHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.progress.tools.reportbug.ui.ViewDetailsDialog");
    }

    public Point getInitialSize() {
        return new Point(400, 600);
    }
}

