/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.preference;

import com.progress.tools.reportbug.model.CustomerType;
import com.progress.tools.reportbug.model.PhoneType;
import com.progress.tools.reportbug.model.Region;
import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.validation.EmailValidator;
import com.progress.tools.reportbug.ui.validation.PhoneExtensionNumberValidator;
import com.progress.tools.reportbug.ui.validation.PhoneNumberValidator;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CustomerInfoComposite
extends Composite {
    private CustomerType customerInfo;
    private Text companyText;
    private Text nameText;
    private Text emailText;
    private Text phoneText;
    private Text phoneExtnText;
    private Combo regionCombo;
    private DataBindingContext dbc;
    private Binding companyTextBinding;
    private Binding nameTextBinding;
    private Binding emailAddressBinding;
    private Binding phoneTextBinding;
    private Binding regionComboBinding;
    private Binding phoneExtnTextBinding;

    public CustomerInfoComposite(Composite parent, DataBindingContext dbc, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.dbc = dbc;
        this.createUI();
    }

    private void createUI() {
        Group customerInfoGroup = new Group((Composite)this, 0);
        customerInfoGroup.setText(Messages.CustomerInfoComposite_CUSTOMER_INFORMATION_GROUP_TITLE);
        customerInfoGroup.setLayout((Layout)new GridLayout(2, false));
        customerInfoGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.companyText = this.createTextWithLabel((Composite)customerInfoGroup, Messages.CustomerInfoComposite_COMPANY_LABEL);
        this.nameText = this.createTextWithLabel((Composite)customerInfoGroup, Messages.CustomerInfoComposite_NAME_LABEL);
        this.emailText = this.createTextWithLabel((Composite)customerInfoGroup, Messages.CustomerInfoComposite_EMAIL_LABEL);
        Label phoneLabel = new Label((Composite)customerInfoGroup, 0);
        phoneLabel.setText(Messages.CustomerInfoComposite_PHONE_LABEL);
        Composite parent = new Composite((Composite)customerInfoGroup, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(4, 4, true, false));
        this.phoneText = new Text(parent, 2048);
        GridData layoutData = new GridData(4, 4, true, false);
        this.phoneText.setLayoutData((Object)layoutData);
        Label label = new Label(parent, 0);
        label.setText(Messages.CustomerInfoComposite_EXTN_LABEL);
        this.phoneExtnText = new Text(parent, 2048);
        this.phoneExtnText.setLayoutData((Object)new GridData(4, 4, false, false));
        Label companyName = new Label((Composite)customerInfoGroup, 0);
        companyName.setText(Messages.CustomerInfoComposite_REGION_LABEL);
        this.regionCombo = new Combo((Composite)customerInfoGroup, 2056);
        layoutData = new GridData(4, 4, true, false);
        this.regionCombo.setLayoutData((Object)layoutData);
        this.regionCombo.setItems(Region.getItems());
    }

    private void addDataBindings() {
        IObservableValue companyObservable = PojoObservables.observeValue((Object)this.customerInfo, (String)"company");
        IObservableValue customerNameObservable = PojoObservables.observeValue((Object)this.customerInfo, (String)"name");
        IObservableValue emailAddressObservable = PojoObservables.observeValue((Object)this.customerInfo, (String)"email");
        IObservableValue phoneNumberObservable = PojoObservables.observeValue((Object)this.customerInfo.getPhone(), (String)"value");
        IObservableValue phoneExtnNumberObservable = PojoObservables.observeValue((Object)this.customerInfo.getPhone(), (String)"extension");
        IObservableValue regionObservable = PojoObservables.observeValue((Object)this.customerInfo, (String)"region");
        UpdateValueStrategy emailValueStrategy = new UpdateValueStrategy();
        emailValueStrategy.setBeforeSetValidator((IValidator)new EmailValidator());
        UpdateValueStrategy phoneValueStrategy = new UpdateValueStrategy();
        phoneValueStrategy.setBeforeSetValidator((IValidator)new PhoneNumberValidator());
        UpdateValueStrategy phoneExtnValueStrategy = new UpdateValueStrategy();
        phoneExtnValueStrategy.setBeforeSetValidator((IValidator)new PhoneExtensionNumberValidator());
        this.companyTextBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.companyText, (int)24), companyObservable, null, null);
        this.nameTextBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.nameText, (int)24), customerNameObservable, null, null);
        this.emailAddressBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.emailText, (int)24), emailAddressObservable, emailValueStrategy, null);
        this.phoneTextBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.phoneText, (int)24), phoneNumberObservable, phoneValueStrategy, null);
        this.phoneExtnTextBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.phoneExtnText, (int)24), phoneExtnNumberObservable, phoneExtnValueStrategy, null);
        this.regionComboBinding = this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.regionCombo), regionObservable);
    }

    public void dispose() {
        this.removeDataBindings();
    }

    private void removeDataBindings() {
        this.dbc.removeBinding(this.companyTextBinding);
        this.dbc.removeBinding(this.nameTextBinding);
        this.dbc.removeBinding(this.emailAddressBinding);
        this.dbc.removeBinding(this.phoneTextBinding);
        this.dbc.removeBinding(this.phoneExtnTextBinding);
        this.dbc.removeBinding(this.regionComboBinding);
    }

    Text createTextWithLabel(Composite parent, String labelName) {
        Label companyName = new Label(parent, 0);
        companyName.setText(labelName);
        Text text = new Text(parent, 2048);
        GridData layoutData = new GridData(4, 4, true, false);
        text.setLayoutData((Object)layoutData);
        return text;
    }

    public CustomerType getCustomerInfo() {
        return this.customerInfo;
    }

    public void setCustomerInfo(CustomerType customerInfo) {
        try {
            this.removeDataBindings();
            if (customerInfo.getPhone() == null) {
                customerInfo.setPhone(new PhoneType());
            }
            this.customerInfo = customerInfo;
            this.updateUI();
        }
        finally {
            this.addDataBindings();
        }
    }

    private void updateUI() {
        if (this.companyText == null) {
            return;
        }
        this.companyText.setText(this.customerInfo.getCompany());
        this.nameText.setText(this.customerInfo.getName());
        this.emailText.setText(this.customerInfo.getEmail());
        PhoneType phone = this.customerInfo.getPhone();
        if (phone != null) {
            if (phone.getValue() != null) {
                this.phoneText.setText(phone.getValue());
            }
            if (phone.getExtension() != null) {
                this.phoneExtnText.setText(phone.getExtension());
            }
        }
        this.regionCombo.select(this.regionCombo.indexOf(this.customerInfo.getRegion()));
    }
}

