/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.wizard.composite;

import com.progress.tools.reportbug.Constants;
import com.progress.tools.reportbug.IProductLog;
import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.wizard.composite.JREPreferences;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;

public class JVMConfigured
implements IProductLog {
    ByteArrayInputStream in = null;

    public String getDescription() {
        return Messages.JVMConfigured_JVM_DESCRIPTION;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public String getName() {
        return Messages.JVMConfigured_JMV_NAME;
    }

    public boolean isCheckedByDefault() {
        return true;
    }

    public void postFinish() {
    }

    public void preFinish() {
        StringBuilder sb = new StringBuilder();
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append(Messages.JVMConfigured_JVM_MEMORY_USAGE).append(Constants.LINE_SEPARATOR).append("\t");
        sb.append(Messages.JVMConfigured_JVM_FREE_MEMORY).append(this.format(freeMemory)).append(Messages.JVMConfigured_IN_KB).append(Constants.LINE_SEPARATOR).append("\t");
        sb.append(Messages.JVMConfigured_ALLOCATED_MEMORY).append(this.format(allocatedMemory)).append(Messages.JVMConfigured_IN_KB).append(Constants.LINE_SEPARATOR).append("\t");
        sb.append(Messages.JVMConfigured_MAX_MEMORY).append(this.format(maxMemory)).append(Messages.JVMConfigured_IN_KB).append(Constants.LINE_SEPARATOR);
        try {
            JREPreferences j = new JREPreferences();
            sb.append(j.getJREPreference());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            sb.append(Constants.LINE_SEPARATOR).append(Messages.JVMConfigured_MESSAGE_ECLIPSE_JDT);
        }
        try {
            this.in = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.in = new ByteArrayInputStream(sb.toString().getBytes());
            e.printStackTrace();
        }
    }

    private String format(long memory) {
        return NumberFormat.getInstance().format(memory / 1024L);
    }
}

