/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.MergeStrategies;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.SubmoduleInitCommand;
import org.eclipse.jgit.api.SubmoduleUpdateCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.team.core.TeamException;

public class SubmoduleUpdateOperation
implements IEGitOperation {
    private final Repository repository;
    private final Collection<String> paths;

    public SubmoduleUpdateOperation(Repository repository) {
        this.repository = repository;
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateOperation addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                final SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)4);
                progress.setTaskName(MessageFormat.format(CoreText.SubmoduleUpdateOperation_updating, RepositoryUtil.INSTANCE.getRepositoryName(SubmoduleUpdateOperation.this.repository)));
                Git git = Git.wrap((Repository)SubmoduleUpdateOperation.this.repository);
                Collection updated = null;
                try {
                    try {
                        SubmoduleInitCommand init = git.submoduleInit();
                        for (String path : SubmoduleUpdateOperation.this.paths) {
                            init.addPath(path);
                        }
                        init.call();
                        progress.worked(1);
                        SubmoduleUpdateCommand update = git.submoduleUpdate();
                        for (String path : SubmoduleUpdateOperation.this.paths) {
                            update.addPath(path);
                        }
                        update.setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(2)));
                        MergeStrategy strategy = MergeStrategies.getPreferredMergeStrategy();
                        if (strategy != null) {
                            update.setStrategy(strategy);
                        }
                        update.setCallback(new CloneCommand.Callback(){

                            public void initializedSubmodules(Collection<String> submodules) {
                            }

                            public void cloningSubmodule(String path) {
                                progress.setTaskName(MessageFormat.format(CoreText.SubmoduleUpdateOperation_cloning, RepositoryUtil.INSTANCE.getRepositoryName(SubmoduleUpdateOperation.this.repository), path));
                            }

                            public void checkingOut(AnyObjectId commit, String path) {
                            }
                        });
                        updated = update.call();
                        SubMonitor refreshMonitor = progress.newChild(1).setWorkRemaining(updated.size());
                        for (String path : updated) {
                            Repository subRepo = SubmoduleWalk.getSubmoduleRepository((Repository)SubmoduleUpdateOperation.this.repository, (String)path);
                            if (subRepo != null) {
                                ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(subRepo), (IProgressMonitor)refreshMonitor.newChild(1));
                                continue;
                            }
                            refreshMonitor.worked(1);
                        }
                    }
                    catch (IOException | GitAPIException e) {
                        throw new TeamException(e.getLocalizedMessage(), e.getCause());
                    }
                }
                finally {
                    if (updated != null && !updated.isEmpty()) {
                        SubmoduleUpdateOperation.this.repository.notifyIndexChanged(true);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

